<?php
/**
 * ISLMS - 帳號管理
 */
include_once 'src/function.php';
check_admin();

$mRole = $_REQUEST['mRole'] ?? '';
$msearchKey = $_REQUEST['mkey'] ?? '';
$mkey = '%' . $msearchKey . '%';

// 分頁設定
$itemsPerPage = 10;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? intval($_GET['page']) : 1;
$page = max(1, $page);

// 計算總筆數
$sqlTotal = "SELECT COUNT(*) FROM users WHERE (account LIKE :mkey OR name LIKE :mkey OR email LIKE :mkey)";
if (!empty($mRole)) {
    $sqlTotal .= " AND role = :mRole";
}
$stmtTotal = $conn->prepare($sqlTotal);
$stmtTotal->bindValue(':mkey', $mkey, PDO::PARAM_STR);
if (!empty($mRole)) {
    $stmtTotal->bindValue(':mRole', $mRole, PDO::PARAM_STR);
}
$stmtTotal->execute();
$totalItems = $stmtTotal->fetchColumn();

// 分頁計算
$pagination = get_pagination($totalItems, $itemsPerPage, $page);

// 查詢資料
$sql = "SELECT user_id, account, role, name, email, status, last_login_at, create_date 
        FROM users WHERE (account LIKE :mkey OR name LIKE :mkey OR email LIKE :mkey)";
if (!empty($mRole)) {
    $sql .= " AND role = :mRole";
}
$sql .= " ORDER BY create_date DESC LIMIT :limit OFFSET :offset";

$stmt = $conn->prepare($sql);
$stmt->bindValue(':mkey', $mkey, PDO::PARAM_STR);
if (!empty($mRole)) {
    $stmt->bindValue(':mRole', $mRole, PDO::PARAM_STR);
}
$stmt->bindValue(':limit', $itemsPerPage, PDO::PARAM_INT);
$stmt->bindValue(':offset', $pagination['offset'], PDO::PARAM_INT);
$stmt->execute();
$data_list = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>帳號管理 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>帳號管理</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active">帳號管理</li>
                </ol>
            </nav>
        </div>

        <div class="container-fluid">
            <?php show_flash(); ?>
            
            <!-- 搜尋區塊 -->
            <div class="card mb-4">
                <div class="card-body mt-3">
                    <form method="GET" action="" id="searchForm" class="d-flex align-items-center w-100">
                        <div class="input-group flex-grow-1" style="max-width: 60%;">
                            <select class="form-select" id="mRole" name="mRole" style="max-width: 180px;" onchange="this.form.submit();">
                                <option value="" <?= $mRole == '' ? 'selected' : '' ?>>帳號權限(全部)</option>
                                <option value="admin" <?= $mRole == 'admin' ? 'selected' : '' ?>>系統管理員</option>
                                <option value="staff" <?= $mRole == 'staff' ? 'selected' : '' ?>>教務承辦</option>
                                <option value="teacher" <?= $mRole == 'teacher' ? 'selected' : '' ?>>授課教師</option>
                            </select>
                            <input type="text" id="mkey" name="mkey" class="form-control" placeholder="請輸入(帳號/姓名/Email)關鍵字搜尋..." value="<?= e($msearchKey) ?>">
                            <button type="submit" class="input-group-text btn btn-primary" title="Search">
                                <i class="bi bi-search"></i> 搜尋
                            </button>
                        </div>
                        <button type="button" class="ms-3 btn btn-outline-secondary" onclick="resetSearch();">
                            <i class="bi bi-arrow-counterclockwise"></i> 重設
                        </button>
                        <a href="users_edit.php" class="ms-3 btn btn-primary">
                            <i class="bi bi-plus-circle"></i> 新增
                        </a>
                    </form>
                </div>
            </div>

            <!-- 資料列表 -->
            <div class="card">
                <div class="card-body mt-4">
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered">
                            <thead>
                                <tr class="table-primary">
                                    <th style="width:60px;">
                                        <a href="users_edit.php" class="btn btn-sm btn-primary" title="新增">
                                            <i class="bi bi-plus-circle"></i>
                                        </a>
                                    </th>
                                    <th style="width:12%;">帳號</th>
                                    <th style="width:12%;">姓名</th>
                                    <th>電子信箱</th>
                                    <th style="width:10%;">權限</th>
                                    <th style="width:120px;">最後登入</th>
                                    <th style="width:100px;">狀態</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (count($data_list) > 0): ?>
                                <?php foreach ($data_list as $data): ?>
                                <tr>
                                    <td>
                                        <a href="users_edit.php?rid=<?= $data['user_id'] ?>" class="btn btn-sm btn-outline-primary" title="編輯">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                    </td>
                                    <td><?= e($data['account']) ?></td>
                                    <td><?= e($data['name']) ?></td>
                                    <td><?= e($data['email']) ?></td>
                                    <td>
                                        <span class="badge bg-<?= $data['role'] == 'admin' ? 'danger' : ($data['role'] == 'staff' ? 'primary' : 'success') ?>">
                                            <?= get_role_name($data['role']) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <small><?= $data['last_login_at'] ? format_datetime($data['last_login_at']) : '-' ?></small>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-<?= $data['status'] ? 'success' : 'secondary' ?>">
                                            <?= $data['status'] ? '啟用' : '停用' ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php else: ?>
                                <tr>
                                    <td colspan="7" class="text-center text-muted py-4">目前沒有資料</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- 分頁 -->
                    <?= render_pagination($pagination, '?' . ($mRole ? "mRole=$mRole&" : '') . ($msearchKey ? "mkey=$msearchKey&" : '')) ?>
                </div>
            </div>
        </div>
    </main>

    <?php include_once "temp_footer.php"; ?>

    <script>
        showSidebar("system", "users_list");

        function resetSearch() {
            document.getElementById('mkey').value = '';
            document.getElementById('mRole').value = '';
            document.getElementById('searchForm').submit();
        }
    </script>
</body>
</html>
