<?php
/**
 * ISLMS - 帳號編輯
 */
include_once 'src/function.php';
check_admin();

$rid = $_GET['rid'] ?? 0;
$isEdit = $rid > 0;
$data = [];
$errors = [];

// 編輯模式：載入資料
if ($isEdit) {
    $stmt = $conn->prepare("SELECT * FROM users WHERE user_id = ?");
    $stmt->execute([$rid]);
    $data = $stmt->fetch();
    if (!$data) {
        set_flash('error', '帳號不存在');
        redirect('users_list.php');
    }
}

// 處理表單提交
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 驗證 CSRF
    if (!verify_csrf($_POST['csrfToken'] ?? '')) {
        $errors[] = 'CSRF 驗證失敗';
    }
    
    $postData = [
        'account' => trim($_POST['account'] ?? ''),
        'name' => trim($_POST['name'] ?? ''),
        'name_en' => trim($_POST['name_en'] ?? ''),
        'email' => trim($_POST['email'] ?? ''),
        'phone' => trim($_POST['phone'] ?? ''),
        'role' => $_POST['role'] ?? 'staff',
        'status' => isset($_POST['status']) ? 1 : 0
    ];
    
    // 驗證
    if (empty($postData['account'])) $errors[] = '帳號為必填';
    if (empty($postData['name'])) $errors[] = '姓名為必填';
    
    // 檢查帳號是否重複
    $stmt = $conn->prepare("SELECT user_id FROM users WHERE account = ? AND user_id != ?");
    $stmt->execute([$postData['account'], $rid ?: 0]);
    if ($stmt->fetch()) {
        $errors[] = '此帳號已存在';
    }
    
    // 新增時密碼必填
    $password = $_POST['password'] ?? '';
    if (!$isEdit && empty($password)) {
        $errors[] = '密碼為必填';
    }
    
    if (empty($errors)) {
        if ($isEdit) {
            // 更新
            $sql = "UPDATE users SET account = ?, name = ?, name_en = ?, email = ?, phone = ?, role = ?, status = ?, updated_by = ? WHERE user_id = ?";
            $params = [$postData['account'], $postData['name'], $postData['name_en'], $postData['email'], $postData['phone'], $postData['role'], $postData['status'], $_SESSION['user_account'], $rid];
            
            // 如果有填密碼則一併更新
            if (!empty($password)) {
                $sql = "UPDATE users SET account = ?, name = ?, name_en = ?, email = ?, phone = ?, role = ?, status = ?, password_hash = ?, updated_by = ? WHERE user_id = ?";
                $params = [$postData['account'], $postData['name'], $postData['name_en'], $postData['email'], $postData['phone'], $postData['role'], $postData['status'], hash_password($password), $_SESSION['user_account'], $rid];
            }
            
            $stmt = $conn->prepare($sql);
            $stmt->execute($params);
            
            write_log('update', 'users', $rid, '更新帳號');
            set_flash('success', '帳號已更新');
        } else {
            // 新增
            $sql = "INSERT INTO users (account, password_hash, name, name_en, email, phone, role, status, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                $postData['account'], hash_password($password), $postData['name'], $postData['name_en'],
                $postData['email'], $postData['phone'], $postData['role'], $postData['status'], $_SESSION['user_account']
            ]);
            
            $newId = $conn->lastInsertId();
            write_log('create', 'users', $newId, '新增帳號');
            set_flash('success', '帳號已新增');
        }
        redirect('users_list.php');
    }
    
    // 保留輸入資料
    $data = array_merge($data, $postData);
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title><?= $isEdit ? '編輯' : '新增' ?>帳號 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1><?= $isEdit ? '編輯' : '新增' ?>帳號</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="users_list.php">帳號管理</a></li>
                    <li class="breadcrumb-item active"><?= $isEdit ? '編輯' : '新增' ?>帳號</li>
                </ol>
            </nav>
        </div>

        <div class="container-fluid">
            <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php foreach ($errors as $err): ?>
                    <li><?= e($err) ?></li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body mt-4">
                    <form method="post">
                        <?= csrf_field() ?>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">帳號 <span class="text-danger">*</span></label>
                                <input type="text" name="account" class="form-control" required 
                                       value="<?= e($data['account'] ?? '') ?>" <?= $isEdit ? 'readonly' : '' ?>>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">密碼 <?= $isEdit ? '(留空不修改)' : '<span class="text-danger">*</span>' ?></label>
                                <input type="password" name="password" class="form-control" <?= $isEdit ? '' : 'required' ?>>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">中文姓名 <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control" required value="<?= e($data['name'] ?? '') ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">英文姓名</label>
                                <input type="text" name="name_en" class="form-control" value="<?= e($data['name_en'] ?? '') ?>">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control" value="<?= e($data['email'] ?? '') ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">電話</label>
                                <input type="text" name="phone" class="form-control" value="<?= e($data['phone'] ?? '') ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">權限</label>
                                <select name="role" class="form-select">
                                    <option value="admin" <?= ($data['role'] ?? '') == 'admin' ? 'selected' : '' ?>>系統管理員</option>
                                    <option value="staff" <?= ($data['role'] ?? 'staff') == 'staff' ? 'selected' : '' ?>>教務承辦</option>
                                    <option value="teacher" <?= ($data['role'] ?? '') == 'teacher' ? 'selected' : '' ?>>授課教師</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <div class="form-check">
                                <input type="checkbox" name="status" class="form-check-input" id="status" 
                                       <?= ($data['status'] ?? 1) ? 'checked' : '' ?>>
                                <label class="form-check-label" for="status">啟用</label>
                            </div>
                        </div>
                        
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-lg me-1"></i>儲存
                            </button>
                            <a href="users_list.php" class="btn btn-secondary">取消</a>
                            <?php if ($isEdit && $rid != $_SESSION['user_id']): ?>
                            <button type="button" class="btn btn-warning ms-auto" onclick="resetPassword(<?= $rid ?>)">
                                <i class="bi bi-key me-1"></i>重設密碼
                            </button>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>

    <?php include_once "temp_footer.php"; ?>

    <script>
        showSidebar("system", "users_list");

        function resetPassword(userId) {
            if (!confirm('確定要重設此帳號的密碼嗎？')) return;
            
            ajaxPost('api/users_api.php', {
                action: 'reset_password',
                user_id: userId
            }, function(res) {
                if (res.success) {
                    alert('新密碼為：' + res.data.password + '\n請告知使用者登入後修改密碼');
                } else {
                    alert(res.message);
                }
            });
        }
    </script>
</body>
</html>
