<?php
/**
 * ISLMS - 成績單管理
 */
include_once 'src/function.php';
check_staff();

$sectionId = intval($_GET['section_id'] ?? 0);

// 產生成績單
if (isset($_GET['generate']) && $sectionId) {
    $enrollmentId = intval($_GET['generate']);
    
    // 取得選課資訊
    $stmt = $conn->prepare("SELECT e.*, s.name as student_name, s.chinese_name, s.student_no,
                                   sec.section_name, o.semester, c.course_name, c.level_code
                            FROM enrollments e
                            JOIN students s ON e.student_id = s.student_id
                            JOIN sections sec ON e.section_id = sec.section_id
                            JOIN offerings o ON sec.offering_id = o.offering_id
                            JOIN courses c ON o.course_id = c.course_id
                            WHERE e.enrollment_id = ?");
    $stmt->execute([$enrollmentId]);
    $enrollment = $stmt->fetch();
    
    if (!$enrollment) {
        set_flash('error', '記錄不存在');
        redirect('transcripts_list.php?section_id=' . $sectionId);
    }
    
    // 取得成績
    $stmt = $conn->prepare("SELECT g.*, gi.item_name, gi.weight
                            FROM grades g
                            JOIN grade_items gi ON g.item_id = gi.item_id
                            WHERE g.enrollment_id = ?
                            ORDER BY gi.sort_order");
    $stmt->execute([$enrollmentId]);
    $grades = $stmt->fetchAll();
    
    // 輸出成績單 HTML
    ?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>成績單 - <?= e($enrollment['student_name']) ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: "Microsoft JhengHei", "Noto Sans TC", sans-serif; padding: 40px; max-width: 800px; margin: 0 auto; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #333; padding-bottom: 20px; }
        .header h1 { font-size: 24px; margin-bottom: 5px; }
        .header h2 { font-size: 16px; color: #666; font-weight: normal; }
        .title { text-align: center; font-size: 20px; margin: 20px 0; font-weight: bold; }
        .info { margin-bottom: 30px; }
        .info table { width: 100%; border-collapse: collapse; }
        .info td { padding: 8px 10px; border: 1px solid #ddd; }
        .info .label { background: #f5f5f5; width: 120px; font-weight: bold; }
        .grades { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        .grades th, .grades td { border: 1px solid #333; padding: 12px; text-align: center; }
        .grades th { background: #4154f1; color: white; }
        .grades tbody tr:nth-child(even) { background: #f9f9f9; }
        .summary { text-align: right; font-size: 18px; margin-bottom: 30px; }
        .summary strong { font-size: 24px; color: #4154f1; }
        .footer { margin-top: 50px; text-align: center; color: #999; font-size: 12px; }
        .print-btn { padding: 10px 30px; background: #4154f1; color: white; border: none; cursor: pointer; font-size: 14px; border-radius: 5px; }
        @media print { 
            .no-print { display: none !important; }
            body { padding: 20px; }
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?= e(get_setting('center_name', '華語教學中心')) ?></h1>
        <h2><?= e(get_setting('center_name_en', 'Chinese Language Center')) ?></h2>
    </div>
    
    <div class="title">學業成績單 Academic Transcript</div>
    
    <div class="info">
        <table>
            <tr>
                <td class="label">學號 Student ID</td>
                <td><?= e($enrollment['student_no']) ?></td>
                <td class="label">學期 Semester</td>
                <td><?= e($enrollment['semester']) ?></td>
            </tr>
            <tr>
                <td class="label">姓名 Name</td>
                <td><?= e($enrollment['student_name']) ?> <?= $enrollment['chinese_name'] ? '(' . e($enrollment['chinese_name']) . ')' : '' ?></td>
                <td class="label">程度 Level</td>
                <td><?= e($enrollment['level_code']) ?></td>
            </tr>
            <tr>
                <td class="label">課程 Course</td>
                <td colspan="3"><?= e($enrollment['course_name']) ?> - <?= e($enrollment['section_name']) ?></td>
            </tr>
        </table>
    </div>
    
    <table class="grades">
        <thead>
            <tr>
                <th>評分項目 Item</th>
                <th>權重 Weight</th>
                <th>分數 Score</th>
                <th>加權分數 Weighted</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($grades as $g): ?>
            <tr>
                <td><?= e($g['item_name']) ?></td>
                <td><?= $g['weight'] ?>%</td>
                <td><?= $g['score'] !== null ? number_format($g['score'], 1) : '-' ?></td>
                <td><?= $g['weighted_score'] !== null ? number_format($g['weighted_score'], 2) : '-' ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    
    <div class="summary">
        總分 Final Score: <strong><?= $enrollment['final_score'] !== null ? number_format($enrollment['final_score'], 1) : '-' ?></strong>
        &nbsp;&nbsp;&nbsp;
        等第 Grade: <strong><?= e($enrollment['final_grade'] ?? '-') ?></strong>
        &nbsp;&nbsp;&nbsp;
        出席率 Attendance: <strong><?= $enrollment['attendance_rate'] !== null ? $enrollment['attendance_rate'] . '%' : '-' ?></strong>
    </div>
    
    <div class="footer">
        <p>列印日期 Print Date: <?= date('Y-m-d H:i:s') ?></p>
    </div>
    
    <div class="text-center mt-4 no-print">
        <button class="print-btn" onclick="window.print()"><i class="bi bi-printer"></i> 列印 Print</button>
        <button class="print-btn" style="background:#6c757d; margin-left:10px;" onclick="window.close()">關閉 Close</button>
    </div>
</body>
</html>
    <?php
    exit;
}

if ($sectionId) {
    // 取得班級資訊
    $stmt = $conn->prepare("SELECT s.*, o.semester, c.course_name, c.level_code 
                            FROM sections s
                            JOIN offerings o ON s.offering_id = o.offering_id
                            JOIN courses c ON o.course_id = c.course_id
                            WHERE s.section_id = ?");
    $stmt->execute([$sectionId]);
    $section = $stmt->fetch();
    
    if (!$section) {
        set_flash('error', '班級不存在');
        redirect('transcripts_list.php');
    }
    
    // 取得學生名單
    $stmt = $conn->prepare("SELECT s.*, e.enrollment_id, e.final_score, e.final_grade, e.attendance_rate
                            FROM students s
                            JOIN enrollments e ON s.student_id = e.student_id
                            WHERE e.section_id = ? AND e.enrollment_status = 'active'
                            ORDER BY s.student_no");
    $stmt->execute([$sectionId]);
    $students = $stmt->fetchAll();
} else {
    // 班級列表
    $sql = "SELECT s.*, o.semester, c.course_name, c.level_code
            FROM sections s
            JOIN offerings o ON s.offering_id = o.offering_id
            JOIN courses c ON o.course_id = c.course_id
            WHERE s.section_status = 'active'
            ORDER BY o.semester DESC, c.course_name";
    $sections = $conn->query($sql)->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>成績單管理 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>成績單管理</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <?php if ($sectionId): ?>
                    <li class="breadcrumb-item"><a href="transcripts_list.php">成績單</a></li>
                    <li class="breadcrumb-item active"><?= e($section['section_name'] ?? '') ?></li>
                    <?php else: ?>
                    <li class="breadcrumb-item active">成績單</li>
                    <?php endif; ?>
                </ol>
            </nav>
        </div>

        <div class="container-fluid">
            <?php show_flash(); ?>
            
            <?php if ($sectionId): ?>
            <!-- 學生成績單列表 -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><i class="bi bi-file-earmark-pdf me-2"></i><?= e($section['course_name']) ?> - <?= e($section['section_name']) ?></span>
                    <a href="transcripts_list.php" class="btn btn-sm btn-outline-secondary">
                        <i class="bi bi-arrow-left me-1"></i>返回
                    </a>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>學號</th>
                                    <th>姓名</th>
                                    <th class="text-center">總分</th>
                                    <th class="text-center">等第</th>
                                    <th class="text-center">出席率</th>
                                    <th class="text-center">狀態</th>
                                    <th width="150">操作</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (empty($students)): ?>
                                <tr><td colspan="8" class="text-center text-muted py-4">此班級尚無學生</td></tr>
                                <?php else: ?>
                                <?php $i = 1; foreach ($students as $s): ?>
                                <tr>
                                    <td><?= $i++ ?></td>
                                    <td><?= e($s['student_no']) ?></td>
                                    <td>
                                        <?= e($s['name']) ?>
                                        <?php if ($s['chinese_name']): ?><br><small class="text-muted"><?= e($s['chinese_name']) ?></small><?php endif; ?>
                                    </td>
                                    <td class="text-center fw-bold"><?= $s['final_score'] !== null ? number_format($s['final_score'], 1) : '-' ?></td>
                                    <td class="text-center">
                                        <?php if ($s['final_grade']): ?>
                                        <span class="badge bg-<?= get_grade_class($s['final_grade']) ?>"><?= $s['final_grade'] ?></span>
                                        <?php else: ?>-<?php endif; ?>
                                    </td>
                                    <td class="text-center"><?= $s['attendance_rate'] !== null ? $s['attendance_rate'] . '%' : '-' ?></td>
                                    <td class="text-center">
                                        <?php if ($s['final_score'] !== null): ?>
                                        <span class="badge bg-success">可列印</span>
                                        <?php else: ?>
                                        <span class="badge bg-secondary">無成績</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($s['final_score'] !== null): ?>
                                        <a href="?section_id=<?= $sectionId ?>&generate=<?= $s['enrollment_id'] ?>" target="_blank" class="btn btn-sm btn-primary">
                                            <i class="bi bi-file-pdf me-1"></i>成績單
                                        </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <?php else: ?>
            <!-- 班級選擇 -->
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>請選擇班級以產生成績單
            </div>
            
            <div class="row">
                <?php if (empty($sections)): ?>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body text-center text-muted py-5">目前沒有可用的班級</div>
                    </div>
                </div>
                <?php else: ?>
                <?php foreach ($sections as $s): ?>
                <div class="col-md-4 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h5 class="card-title"><?= e($s['course_name']) ?></h5>
                            <h6 class="card-subtitle mb-2 text-muted"><?= e($s['section_name']) ?></h6>
                            <p class="card-text">
                                <span class="badge bg-info"><?= e($s['level_code']) ?></span>
                                <span class="badge bg-secondary"><?= e($s['semester']) ?></span>
                            </p>
                        </div>
                        <div class="card-footer bg-transparent">
                            <a href="?section_id=<?= $s['section_id'] ?>" class="btn btn-primary btn-sm w-100">
                                <i class="bi bi-file-earmark-pdf me-1"></i>管理成績單
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <?php include_once "temp_footer.php"; ?>
    <script>showSidebar("grades", "transcripts_list");</script>
</body>
</html>
