<!-- ======= Sidebar ======= -->
<aside id="sidebar" class="sidebar">

  <ul class="sidebar-nav" id="sidebar-nav">

    <!-- 儀表板 -->
    <li class="nav-item">
      <a class="nav-link" href="index.php">
        <i class="bi bi-grid"></i>
        <span>儀表板</span>
      </a>
    </li>

    <?php if (has_role(['admin', 'staff'])): ?>
    <!-- 學生管理 -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#students-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-people"></i><span>學生管理</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="students-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
        <li>
          <a href="students_list.php" id="students_list">
            <i class="bi bi-circle"></i><span>學生列表</span>
          </a>
        </li>
        <li>
          <a href="students_import.php" id="students_import">
            <i class="bi bi-circle"></i><span>批次匯入</span>
          </a>
        </li>
      </ul>
    </li>

    <!-- 開班管理 -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#offerings-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-calendar-check"></i><span>開班管理</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="offerings-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
        <li>
          <a href="offerings_list.php" id="offerings_list">
            <i class="bi bi-circle"></i><span>開班列表</span>
          </a>
        </li>
        <li>
          <a href="offerings_edit.php" id="offerings_edit">
            <i class="bi bi-circle"></i><span>新增開班</span>
          </a>
        </li>
      </ul>
    </li>
    <?php endif; ?>

    <!-- 班級管理 -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#sections-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-collection"></i><span>班級管理</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="sections-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
        <li>
          <a href="sections_list.php" id="sections_list">
            <i class="bi bi-circle"></i><span>班級列表</span>
          </a>
        </li>
      </ul>
    </li>

    <!-- 點名管理 -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#attendance-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-clipboard-check"></i><span>點名管理</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="attendance-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
        <li>
          <a href="attendance_list.php" id="attendance_list">
            <i class="bi bi-circle"></i><span>點名作業</span>
          </a>
        </li>
      </ul>
    </li>

    <!-- 成績管理 -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#grades-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-journal-text"></i><span>成績管理</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="grades-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
        <li>
          <a href="grades_list.php" id="grades_list">
            <i class="bi bi-circle"></i><span>成績輸入</span>
          </a>
        </li>
        <?php if (has_role(['admin', 'staff'])): ?>
        <li>
          <a href="transcripts_list.php" id="transcripts_list">
            <i class="bi bi-circle"></i><span>成績單</span>
          </a>
        </li>
        <?php endif; ?>
      </ul>
    </li>

    <!-- 統計報表 -->
    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#reports-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-bar-chart"></i><span>統計報表</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="reports-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
        <li>
          <a href="report_attendance.php" id="report_attendance">
            <i class="bi bi-circle"></i><span>出席統計</span>
          </a>
        </li>
        <li>
          <a href="report_grades.php" id="report_grades">
            <i class="bi bi-circle"></i><span>成績統計</span>
          </a>
        </li>
      </ul>
    </li>

    <?php if (has_role(['admin'])): ?>
    <!-- 系統管理 -->
    <li class="nav-heading">系統管理</li>

    <li class="nav-item">
      <a class="nav-link collapsed" data-bs-target="#system-nav" data-bs-toggle="collapse" href="#">
        <i class="bi bi-gear"></i><span>系統設定</span><i class="bi bi-chevron-down ms-auto"></i>
      </a>
      <ul id="system-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
        <li>
          <a href="users_list.php" id="users_list">
            <i class="bi bi-circle"></i><span>帳號管理</span>
          </a>
        </li>
        <li>
          <a href="courses_list.php" id="courses_list">
            <i class="bi bi-circle"></i><span>課程設定</span>
          </a>
        </li>
        <li>
          <a href="settings_list.php" id="settings_list">
            <i class="bi bi-circle"></i><span>系統設定</span>
          </a>
        </li>
        <li>
          <a href="logs_list.php" id="logs_list">
            <i class="bi bi-circle"></i><span>系統日誌</span>
          </a>
        </li>
      </ul>
    </li>
    <?php endif; ?>

  </ul>

  <div class="m-3">
    <hr>
    <small class="text-muted">Version: <?= APP_VERSION ?></small>
  </div>

</aside><!-- End Sidebar-->
