<!-- ======= Footer ======= -->
<footer id="footer" class="footer">
  <div class="copyright">
    &copy; Copyright <strong><span><?= APP_NAME ?></span></strong>. All Rights Reserved
  </div>
  <div class="credits">
    Designed by <a href="#">ISLMS Team</a>
  </div>
</footer><!-- End Footer -->

<a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

<!-- Vendor JS Files -->
<script src="assets/vendor/apexcharts/apexcharts.min.js"></script>
<script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="assets/vendor/chart.js/chart.umd.js"></script>
<script src="assets/vendor/echarts/echarts.min.js"></script>
<script src="assets/vendor/quill/quill.min.js"></script>
<script src="assets/vendor/simple-datatables/simple-datatables.js"></script>
<script src="assets/vendor/tinymce/tinymce.min.js"></script>
<script src="assets/vendor/php-email-form/validate.js"></script>

<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- Template Main JS File -->
<script src="assets/js/main.js"></script>

<script>
// CSRF Token
const csrfToken = '<?= $csrfToken ?? '' ?>';

// 顯示側邊欄選單
function showSidebar(parentId, menuId) {
    // 展開父選單
    const parentNav = document.getElementById(parentId + '-nav');
    if (parentNav) {
        parentNav.classList.add('show');
        const parentLink = parentNav.previousElementSibling;
        if (parentLink) {
            parentLink.classList.remove('collapsed');
        }
    }
    
    // 標記當前選單
    const menuItem = document.getElementById(menuId);
    if (menuItem) {
        menuItem.classList.add('active');
    }
}

// Toast 訊息
function showToast(message, type = 'success') {
    const bgClass = type === 'success' ? 'bg-success' : (type === 'error' ? 'bg-danger' : 'bg-info');
    const toast = `
        <div class="toast-container position-fixed top-0 end-0 p-3">
            <div class="toast show ${bgClass} text-white" role="alert">
                <div class="toast-body d-flex justify-content-between align-items-center">
                    ${message}
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
                </div>
            </div>
        </div>`;
    $('body').append(toast);
    setTimeout(() => { $('.toast-container').remove(); }, 3000);
}

// 確認刪除
function confirmDelete(url, message = '確定要刪除嗎？') {
    if (confirm(message)) {
        window.location.href = url;
    }
}

// AJAX POST
function ajaxPost(url, data, callback) {
    data.csrfToken = csrfToken;
    $.post(url, data, callback, 'json').fail(function(xhr) {
        alert('操作失敗：' + xhr.responseText);
    });
}
</script>
