<?php
/**
 * ISLMS - 學生管理
 */
include_once 'src/function.php';
check_staff();

$mLevel = $_REQUEST['mLevel'] ?? '';
$msearchKey = $_REQUEST['mkey'] ?? '';
$mkey = '%' . $msearchKey . '%';

// 分頁設定
$itemsPerPage = 15;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? intval($_GET['page']) : 1;
$page = max(1, $page);

// 計算總筆數
$sqlTotal = "SELECT COUNT(*) FROM students WHERE status = 1 AND (student_no LIKE :mkey OR name LIKE :mkey OR chinese_name LIKE :mkey OR email LIKE :mkey)";
if (!empty($mLevel)) {
    $sqlTotal .= " AND level_code = :mLevel";
}
$stmtTotal = $conn->prepare($sqlTotal);
$stmtTotal->bindValue(':mkey', $mkey, PDO::PARAM_STR);
if (!empty($mLevel)) {
    $stmtTotal->bindValue(':mLevel', $mLevel, PDO::PARAM_STR);
}
$stmtTotal->execute();
$totalItems = $stmtTotal->fetchColumn();

$pagination = get_pagination($totalItems, $itemsPerPage, $page);

// 查詢資料
$sql = "SELECT * FROM students WHERE status = 1 AND (student_no LIKE :mkey OR name LIKE :mkey OR chinese_name LIKE :mkey OR email LIKE :mkey)";
if (!empty($mLevel)) {
    $sql .= " AND level_code = :mLevel";
}
$sql .= " ORDER BY student_no LIMIT :limit OFFSET :offset";

$stmt = $conn->prepare($sql);
$stmt->bindValue(':mkey', $mkey, PDO::PARAM_STR);
if (!empty($mLevel)) {
    $stmt->bindValue(':mLevel', $mLevel, PDO::PARAM_STR);
}
$stmt->bindValue(':limit', $itemsPerPage, PDO::PARAM_INT);
$stmt->bindValue(':offset', $pagination['offset'], PDO::PARAM_INT);
$stmt->execute();
$data_list = $stmt->fetchAll();

// 程度列表
$levels = get_levels();
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>學生管理 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>學生管理</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active">學生管理</li>
                </ol>
            </nav>
        </div>

        <div class="container-fluid">
            <?php show_flash(); ?>
            
            <!-- 搜尋區塊 -->
            <div class="card mb-4">
                <div class="card-body mt-3">
                    <form method="GET" action="" id="searchForm" class="d-flex align-items-center flex-wrap gap-2">
                        <select class="form-select" id="mLevel" name="mLevel" style="width: 180px;" onchange="this.form.submit();">
                            <option value="">程度(全部)</option>
                            <?php foreach ($levels as $lv): ?>
                            <option value="<?= e($lv['level_code']) ?>" <?= $mLevel == $lv['level_code'] ? 'selected' : '' ?>>
                                <?= e($lv['level_code']) ?> - <?= e($lv['level_name']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                        <div class="input-group" style="width: 350px;">
                            <input type="text" id="mkey" name="mkey" class="form-control" placeholder="學號/姓名/Email..." value="<?= e($msearchKey) ?>">
                            <button type="submit" class="btn btn-primary"><i class="bi bi-search"></i></button>
                        </div>
                        <button type="button" class="btn btn-outline-secondary" onclick="resetSearch();">
                            <i class="bi bi-arrow-counterclockwise"></i> 重設
                        </button>
                        <a href="students_edit.php" class="btn btn-primary">
                            <i class="bi bi-plus-circle"></i> 新增
                        </a>
                        <a href="students_import.php" class="btn btn-success">
                            <i class="bi bi-upload"></i> 匯入
                        </a>
                    </form>
                </div>
            </div>

            <!-- 資料列表 -->
            <div class="card">
                <div class="card-body mt-4">
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered">
                            <thead>
                                <tr class="table-primary">
                                    <th style="width:60px;">
                                        <a href="students_edit.php" class="btn btn-sm btn-primary" title="新增">
                                            <i class="bi bi-plus-circle"></i>
                                        </a>
                                    </th>
                                    <th style="width:10%;">學號</th>
                                    <th>姓名</th>
                                    <th>中文姓名</th>
                                    <th style="width:8%;">國籍</th>
                                    <th style="width:8%;">程度</th>
                                    <th>Email</th>
                                    <th style="width:8%;">類型</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (count($data_list) > 0): ?>
                                <?php foreach ($data_list as $data): ?>
                                <tr>
                                    <td>
                                        <a href="students_edit.php?rid=<?= $data['student_id'] ?>" class="btn btn-sm btn-outline-primary" title="編輯">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                    </td>
                                    <td><?= e($data['student_no']) ?></td>
                                    <td><?= e($data['name']) ?></td>
                                    <td><?= e($data['chinese_name']) ?></td>
                                    <td><?= e($data['nationality']) ?></td>
                                    <td><span class="badge bg-info"><?= e($data['level_code']) ?></span></td>
                                    <td><small><?= e($data['email']) ?></small></td>
                                    <td>
                                        <span class="badge bg-<?= $data['student_type'] == 'degree' ? 'primary' : 'success' ?>">
                                            <?= $data['student_type'] == 'degree' ? '學位生' : '交換生' ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                                <?php else: ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted py-4">目前沒有資料</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <?= render_pagination($pagination, '?' . ($mLevel ? "mLevel=$mLevel&" : '') . ($msearchKey ? "mkey=$msearchKey&" : '')) ?>
                </div>
            </div>
        </div>
    </main>

    <?php include_once "temp_footer.php"; ?>

    <script>
        showSidebar("students", "students_list");

        function resetSearch() {
            document.getElementById('mkey').value = '';
            document.getElementById('mLevel').value = '';
            document.getElementById('searchForm').submit();
        }
    </script>
</body>
</html>
