<?php
/**
 * ISLMS - 學生編輯
 */
include_once 'src/function.php';
check_staff();

$rid = $_GET['rid'] ?? 0;
$isEdit = $rid > 0;
$data = [];
$errors = [];

if ($isEdit) {
    $stmt = $conn->prepare("SELECT * FROM students WHERE student_id = ?");
    $stmt->execute([$rid]);
    $data = $stmt->fetch();
    if (!$data) {
        set_flash('error', '學生不存在');
        redirect('students_list.php');
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf($_POST['csrfToken'] ?? '')) {
        $errors[] = 'CSRF 驗證失敗';
    }
    
    $postData = [
        'student_no' => trim($_POST['student_no'] ?? ''),
        'name' => trim($_POST['name'] ?? ''),
        'chinese_name' => trim($_POST['chinese_name'] ?? ''),
        'nationality' => trim($_POST['nationality'] ?? ''),
        'gender' => $_POST['gender'] ?? 'M',
        'level_code' => $_POST['level_code'] ?? '',
        'email' => trim($_POST['email'] ?? ''),
        'phone' => trim($_POST['phone'] ?? ''),
        'student_type' => $_POST['student_type'] ?? 'exchange',
        'note' => trim($_POST['note'] ?? '')
    ];
    
    if (empty($postData['student_no'])) $errors[] = '學號為必填';
    if (empty($postData['name'])) $errors[] = '姓名為必填';
    
    // 檢查學號重複
    $stmt = $conn->prepare("SELECT student_id FROM students WHERE student_no = ? AND student_id != ?");
    $stmt->execute([$postData['student_no'], $rid ?: 0]);
    if ($stmt->fetch()) $errors[] = '此學號已存在';
    
    if (empty($errors)) {
        if ($isEdit) {
            $sql = "UPDATE students SET student_no=?, name=?, chinese_name=?, nationality=?, gender=?, level_code=?, email=?, phone=?, student_type=?, note=?, updated_by=? WHERE student_id=?";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                $postData['student_no'], $postData['name'], $postData['chinese_name'], $postData['nationality'],
                $postData['gender'], $postData['level_code'], $postData['email'], $postData['phone'],
                $postData['student_type'], $postData['note'], $_SESSION['user_account'], $rid
            ]);
            write_log('update', 'students', $rid, '更新學生');
            set_flash('success', '學生資料已更新');
        } else {
            $sql = "INSERT INTO students (student_no, name, chinese_name, nationality, gender, level_code, email, phone, student_type, note, status, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,1,?)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                $postData['student_no'], $postData['name'], $postData['chinese_name'], $postData['nationality'],
                $postData['gender'], $postData['level_code'], $postData['email'], $postData['phone'],
                $postData['student_type'], $postData['note'], $_SESSION['user_account']
            ]);
            write_log('create', 'students', $conn->lastInsertId(), '新增學生');
            set_flash('success', '學生已新增');
        }
        redirect('students_list.php');
    }
    $data = array_merge($data, $postData);
}

$levels = get_levels();
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title><?= $isEdit ? '編輯' : '新增' ?>學生 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1><?= $isEdit ? '編輯' : '新增' ?>學生</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="students_list.php">學生管理</a></li>
                    <li class="breadcrumb-item active"><?= $isEdit ? '編輯' : '新增' ?>學生</li>
                </ol>
            </nav>
        </div>

        <div class="container-fluid">
            <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
                <ul class="mb-0"><?php foreach ($errors as $err): ?><li><?= e($err) ?></li><?php endforeach; ?></ul>
            </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body mt-4">
                    <form method="post">
                        <?= csrf_field() ?>
                        
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">學號 <span class="text-danger">*</span></label>
                                <input type="text" name="student_no" class="form-control" required value="<?= e($data['student_no'] ?? '') ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">英文姓名 <span class="text-danger">*</span></label>
                                <input type="text" name="name" class="form-control" required value="<?= e($data['name'] ?? '') ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">中文姓名</label>
                                <input type="text" name="chinese_name" class="form-control" value="<?= e($data['chinese_name'] ?? '') ?>">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">國籍</label>
                                <input type="text" name="nationality" class="form-control" value="<?= e($data['nationality'] ?? '') ?>">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">性別</label>
                                <select name="gender" class="form-select">
                                    <option value="M" <?= ($data['gender'] ?? 'M') == 'M' ? 'selected' : '' ?>>男</option>
                                    <option value="F" <?= ($data['gender'] ?? '') == 'F' ? 'selected' : '' ?>>女</option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">程度</label>
                                <select name="level_code" class="form-select">
                                    <option value="">請選擇</option>
                                    <?php foreach ($levels as $lv): ?>
                                    <option value="<?= e($lv['level_code']) ?>" <?= ($data['level_code'] ?? '') == $lv['level_code'] ? 'selected' : '' ?>>
                                        <?= e($lv['level_code']) ?> - <?= e($lv['level_name']) ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">學生類型</label>
                                <select name="student_type" class="form-select">
                                    <option value="exchange" <?= ($data['student_type'] ?? '') == 'exchange' ? 'selected' : '' ?>>交換生</option>
                                    <option value="degree" <?= ($data['student_type'] ?? '') == 'degree' ? 'selected' : '' ?>>學位生</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Email</label>
                                <input type="email" name="email" class="form-control" value="<?= e($data['email'] ?? '') ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">電話</label>
                                <input type="text" name="phone" class="form-control" value="<?= e($data['phone'] ?? '') ?>">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">備註</label>
                            <textarea name="note" class="form-control" rows="2"><?= e($data['note'] ?? '') ?></textarea>
                        </div>
                        
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>儲存</button>
                            <a href="students_list.php" class="btn btn-secondary">取消</a>
                            <?php if ($isEdit): ?>
                            <button type="button" class="btn btn-danger ms-auto" onclick="deleteStudent(<?= $rid ?>)">
                                <i class="bi bi-trash me-1"></i>刪除
                            </button>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>

    <?php include_once "temp_footer.php"; ?>

    <script>
        showSidebar("students", "students_list");

        function deleteStudent(id) {
            if (!confirm('確定要刪除此學生嗎？')) return;
            ajaxPost('api/students_api.php', {action: 'delete', student_id: id}, function(res) {
                if (res.success) {
                    window.location.href = 'students_list.php';
                } else {
                    alert(res.message);
                }
            });
        }
    </script>
</body>
</html>
