<?php
/**
 * ISLMS - 全域變數設定
 */
@header("Cache-Control: no-cache, must-revalidate");
@header("Content-Type: text/html; charset=utf-8");
ob_start();
session_start();

include_once __DIR__ . '/config.php';
include_once __DIR__ . '/db.php';
date_default_timezone_set('Asia/Taipei');

// Session 時間延長 2小時
$_SESSION['LAST_ACTIVITY'] = time();
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > 7200)) {
    session_unset();
    session_destroy();
    header('Location: login.php');
    exit;
}

// 常用日期變數
$today = date("Y-m-d");
$now = date("Y-m-d H:i:s");
$oneHourLater = date("Y-m-d H:i:s", strtotime($now . " +1 hour"));
$oneHourBefore = date("Y-m-d H:i:s", strtotime($now . " -1 hour"));
$nextYear = date("Y-m-d", strtotime($today . " +1 year"));
$lastWeek = date("Y-m-d", strtotime($today . " -7 days"));
$yesterday = date("Y-m-d", strtotime($today . " -1 days"));

// 目前使用者角色
$mSysAdmin = $_SESSION['user_role'] ?? 'user';
$mUserId = $_SESSION['user_id'] ?? 0;
$mUserName = $_SESSION['user_name'] ?? '';
$mUserAccount = $_SESSION['user_account'] ?? '';

// 生成 CSRF token
if (empty($_SESSION['csrfToken'])) {
    $_SESSION['csrfToken'] = bin2hex(random_bytes(32));
}
$csrfToken = $_SESSION['csrfToken'];

// 取得客戶端 IP
if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    $client_ip = $_SERVER['HTTP_CLIENT_IP'];
} elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $client_ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
} else {
    $client_ip = $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1';
}

// Base64 URL 編碼解碼
function base64url_encode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function base64url_decode($data) {
    return base64_decode(str_pad(strtr($data, '-_', '+/'), strlen($data) % 4, '=', STR_PAD_RIGHT));
}
