<?php
/**
 * ISLMS - 班級列表
 */
include_once 'src/function.php';
check_login();

// 查詢班級
if ($_SESSION['user_role'] === 'teacher') {
    $stmt = $conn->prepare("SELECT s.*, o.semester, c.course_name, c.level_code, u.name as teacher_name,
                            (SELECT COUNT(*) FROM enrollments e WHERE e.section_id = s.section_id AND e.enrollment_status = 'active') as student_count
                            FROM sections s
                            JOIN offerings o ON s.offering_id = o.offering_id
                            JOIN courses c ON o.course_id = c.course_id
                            LEFT JOIN users u ON COALESCE(s.teacher_id, o.teacher_id) = u.user_id
                            WHERE (s.teacher_id = ? OR o.teacher_id = ?) AND o.offering_status = 'active'
                            ORDER BY c.course_name, s.section_name");
    $stmt->execute([$_SESSION['user_id'], $_SESSION['user_id']]);
    $sections = $stmt->fetchAll();
} else {
    $sql = "SELECT s.*, o.semester, c.course_name, c.level_code, u.name as teacher_name,
            (SELECT COUNT(*) FROM enrollments e WHERE e.section_id = s.section_id AND e.enrollment_status = 'active') as student_count
            FROM sections s
            JOIN offerings o ON s.offering_id = o.offering_id
            JOIN courses c ON o.course_id = c.course_id
            LEFT JOIN users u ON COALESCE(s.teacher_id, o.teacher_id) = u.user_id
            WHERE o.offering_status = 'active'
            ORDER BY o.semester DESC, c.course_name, s.section_name";
    $sections = $conn->query($sql)->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>班級列表 - <?= APP_NAME ?></title>
  <?php include_once "temp_head.php"; ?>
</head>
<body>
  <?php include_once "temp_header.php"; ?>
  <?php include_once "temp_sidebar.php"; ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>班級列表</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">班級列表</li>
        </ol>
      </nav>
    </div>

    <div class="container-fluid">
      <?php show_flash(); ?>
      
      <div class="card">
        <div class="card-body mt-4">
          <div class="table-responsive">
            <table class="table table-hover table-bordered">
              <thead>
                <tr class="table-primary">
                  <th style="width:60px;"></th>
                  <th>學期</th>
                  <th>課程名稱</th>
                  <th>班級</th>
                  <th>程度</th>
                  <th>授課教師</th>
                  <th class="text-center">學生數</th>
                  <th width="180">操作</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($sections)): ?>
                <tr><td colspan="8" class="text-center text-muted py-4">目前沒有班級資料</td></tr>
                <?php else: ?>
                <?php foreach ($sections as $s): ?>
                <tr>
                  <td>
                    <a href="sections_view.php?id=<?= $s['section_id'] ?>" class="btn btn-sm btn-outline-info" title="查看">
                      <i class="bi bi-eye"></i>
                    </a>
                  </td>
                  <td><?= e($s['semester']) ?></td>
                  <td><?= e($s['course_name']) ?></td>
                  <td><strong><?= e($s['section_name']) ?></strong></td>
                  <td><span class="badge bg-info"><?= e($s['level_code']) ?></span></td>
                  <td><?= e($s['teacher_name'] ?? '-') ?></td>
                  <td class="text-center">
                    <span class="badge bg-primary"><?= $s['student_count'] ?></span>
                    / <?= $s['max_students'] ?>
                  </td>
                  <td>
                    <a href="sections_view.php?id=<?= $s['section_id'] ?>" class="btn btn-sm btn-outline-info">名單</a>
                    <a href="attendance_entry.php?section_id=<?= $s['section_id'] ?>" class="btn btn-sm btn-outline-success">點名</a>
                    <a href="grades_entry.php?section_id=<?= $s['section_id'] ?>" class="btn btn-sm btn-outline-warning">成績</a>
                  </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </main>

  <?php include_once "temp_footer.php"; ?>
  <script>showSidebar("sections", "sections_list");</script>
</body>
</html>
