<?php
/**
 * ISLMS - 成績統計報表
 */
include_once 'src/function.php';
check_login();

$mOffering = $_REQUEST['offering_id'] ?? '';
$mLevel = $_REQUEST['level_code'] ?? '';

// CSV 匯出
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    $sql = "SELECT s.student_no, s.name, s.chinese_name, c.course_name, sec.section_name,
                   e.final_score, e.final_grade, e.attendance_rate
            FROM students s
            JOIN enrollments e ON s.student_id = e.student_id
            JOIN sections sec ON e.section_id = sec.section_id
            JOIN offerings o ON sec.offering_id = o.offering_id
            JOIN courses c ON o.course_id = c.course_id
            WHERE e.enrollment_status = 'active'";
    
    if ($mOffering) $sql .= " AND o.offering_id = " . intval($mOffering);
    if ($mLevel) $sql .= " AND c.level_code = " . $conn->quote($mLevel);
    $sql .= " ORDER BY c.course_name, sec.section_name, s.student_no";
    
    $data = $conn->query($sql)->fetchAll();
    
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="grades_report_' . date('Ymd') . '.csv"');
    echo "\xEF\xBB\xBF";
    
    $out = fopen('php://output', 'w');
    fputcsv($out, ['學號', '姓名', '中文姓名', '課程', '班級', '總分', '等第', '出席率']);
    
    foreach ($data as $row) {
        fputcsv($out, [
            $row['student_no'], $row['name'], $row['chinese_name'], $row['course_name'], $row['section_name'],
            $row['final_score'] !== null ? number_format($row['final_score'], 1) : '',
            $row['final_grade'] ?? '',
            $row['attendance_rate'] !== null ? $row['attendance_rate'] . '%' : ''
        ]);
    }
    fclose($out);
    exit;
}

// 查詢報表資料
$reportData = [];
if ($mOffering || $mLevel) {
    $sql = "SELECT s.student_no, s.name, s.chinese_name, c.course_name, sec.section_name,
                   e.final_score, e.final_grade, e.attendance_rate
            FROM students s
            JOIN enrollments e ON s.student_id = e.student_id
            JOIN sections sec ON e.section_id = sec.section_id
            JOIN offerings o ON sec.offering_id = o.offering_id
            JOIN courses c ON o.course_id = c.course_id
            WHERE e.enrollment_status = 'active'";
    
    if ($mOffering) $sql .= " AND o.offering_id = " . intval($mOffering);
    if ($mLevel) $sql .= " AND c.level_code = " . $conn->quote($mLevel);
    $sql .= " ORDER BY c.course_name, sec.section_name, s.student_no";
    
    $reportData = $conn->query($sql)->fetchAll();
}

$offerings = $conn->query("SELECT o.offering_id, o.semester, c.course_name FROM offerings o JOIN courses c ON o.course_id = c.course_id WHERE o.offering_status IN ('active', 'closed') ORDER BY o.semester DESC, c.course_name")->fetchAll();
$levels = get_levels();
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>成績統計報表 - <?= APP_NAME ?></title>
  <?php include_once "temp_head.php"; ?>
</head>
<body>
  <?php include_once "temp_header.php"; ?>
  <?php include_once "temp_sidebar.php"; ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>成績統計報表</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">成績統計報表</li>
        </ol>
      </nav>
    </div>

    <div class="container-fluid">
      <div class="card mb-4">
        <div class="card-body mt-3">
          <form method="GET" class="row g-3 align-items-end">
            <div class="col-md-4">
              <label class="form-label">課程</label>
              <select name="offering_id" class="form-select">
                <option value="">請選擇</option>
                <?php foreach ($offerings as $o): ?>
                <option value="<?= $o['offering_id'] ?>" <?= $mOffering == $o['offering_id'] ? 'selected' : '' ?>>
                  <?= e($o['course_name']) ?> (<?= e($o['semester']) ?>)
                </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-3">
              <label class="form-label">程度</label>
              <select name="level_code" class="form-select">
                <option value="">全部</option>
                <?php foreach ($levels as $l): ?>
                <option value="<?= e($l['level_code']) ?>" <?= $mLevel == $l['level_code'] ? 'selected' : '' ?>><?= e($l['level_code']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-auto">
              <button type="submit" class="btn btn-primary"><i class="bi bi-search me-1"></i>查詢</button>
              <a href="report_grades.php" class="btn btn-outline-secondary">重設</a>
              <?php if (!empty($reportData)): ?>
              <a href="?<?= http_build_query($_GET) ?>&export=csv" class="btn btn-success">
                <i class="bi bi-download me-1"></i>匯出
              </a>
              <?php endif; ?>
            </div>
          </form>
        </div>
      </div>

      <div class="card">
        <div class="card-header">
          <i class="bi bi-table me-2"></i>成績統計
          <?php if (!empty($reportData)): ?>
          <span class="badge bg-secondary ms-2"><?= count($reportData) ?> 筆</span>
          <?php endif; ?>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-hover mb-0" id="reportTable">
              <thead>
                <tr class="table-primary">
                  <th>學號</th>
                  <th>姓名</th>
                  <th>課程</th>
                  <th>班級</th>
                  <th class="text-center">總分</th>
                  <th class="text-center">等第</th>
                  <th class="text-center">出席率</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($reportData)): ?>
                <tr><td colspan="7" class="text-center text-muted py-4">請選擇篩選條件後查詢</td></tr>
                <?php else: ?>
                <?php foreach ($reportData as $row): ?>
                <tr>
                  <td><?= e($row['student_no']) ?></td>
                  <td><?= e($row['name']) ?><?= $row['chinese_name'] ? ' (' . e($row['chinese_name']) . ')' : '' ?></td>
                  <td><?= e($row['course_name']) ?></td>
                  <td><?= e($row['section_name']) ?></td>
                  <td class="text-center fw-bold"><?= $row['final_score'] !== null ? number_format($row['final_score'], 1) : '-' ?></td>
                  <td class="text-center">
                    <?php if ($row['final_grade']): ?>
                    <span class="badge bg-<?= get_grade_class($row['final_grade']) ?>"><?= $row['final_grade'] ?></span>
                    <?php else: ?>-<?php endif; ?>
                  </td>
                  <td class="text-center"><?= $row['attendance_rate'] !== null ? $row['attendance_rate'] . '%' : '-' ?></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </main>

  <?php include_once "temp_footer.php"; ?>
  <script>
    showSidebar("reports", "report_grades");
    
    document.addEventListener('DOMContentLoaded', function() {
      if (document.querySelector('#reportTable tbody tr').querySelector('td[colspan]') === null) {
        new simpleDatatables.DataTable('#reportTable', {
          perPage: 20,
          labels: { placeholder: "搜尋...", perPage: "每頁 {select} 筆", noRows: "沒有資料", info: "顯示 {start} 到 {end} 筆，共 {rows} 筆" }
        });
      }
    });
  </script>
</body>
</html>
