<?php
/**
 * ISLMS - 出席統計報表
 */
include_once 'src/function.php';
check_login();

$mOffering = $_REQUEST['offering_id'] ?? '';
$mLevel = $_REQUEST['level_code'] ?? '';
$startDate = $_REQUEST['start_date'] ?? '';
$endDate = $_REQUEST['end_date'] ?? '';

// CSV 匯出
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    $sql = "SELECT s.student_no, s.name, s.chinese_name, c.course_name, sec.section_name, sec.section_id
            FROM students s
            JOIN enrollments e ON s.student_id = e.student_id
            JOIN sections sec ON e.section_id = sec.section_id
            JOIN offerings o ON sec.offering_id = o.offering_id
            JOIN courses c ON o.course_id = c.course_id
            WHERE e.enrollment_status = 'active'";
    
    if ($mOffering) $sql .= " AND o.offering_id = " . intval($mOffering);
    if ($mLevel) $sql .= " AND c.level_code = " . $conn->quote($mLevel);
    $sql .= " ORDER BY c.course_name, sec.section_name, s.student_no";
    
    $data = $conn->query($sql)->fetchAll();
    
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="attendance_report_' . date('Ymd') . '.csv"');
    echo "\xEF\xBB\xBF"; // UTF-8 BOM
    
    $out = fopen('php://output', 'w');
    fputcsv($out, ['學號', '姓名', '中文姓名', '課程', '班級', '總堂', '出席', '遲到', '缺席', '請假', '出席率']);
    
    foreach ($data as $row) {
        // 計算出席統計
        $stmt = $conn->prepare("SELECT attendance_status, COUNT(*) as cnt FROM attendance 
                                WHERE section_id = ? AND student_id = (SELECT student_id FROM students WHERE student_no = ?)
                                GROUP BY attendance_status");
        $stmt->execute([$row['section_id'], $row['student_no']]);
        $stats = [];
        $total = 0;
        foreach ($stmt->fetchAll() as $st) {
            $stats[$st['attendance_status']] = $st['cnt'];
            $total += $st['cnt'];
        }
        $present = ($stats['P'] ?? 0) + ($stats['L'] ?? 0) * 0.5;
        $rate = $total > 0 ? round($present / $total * 100, 1) : 0;
        
        fputcsv($out, [
            $row['student_no'], $row['name'], $row['chinese_name'], $row['course_name'], $row['section_name'],
            $total, $stats['P'] ?? 0, $stats['L'] ?? 0, $stats['A'] ?? 0, ($stats['E'] ?? 0) + ($stats['O'] ?? 0) + ($stats['S'] ?? 0),
            $rate . '%'
        ]);
    }
    fclose($out);
    exit;
}

// 查詢報表資料
$reportData = [];
if ($mOffering || $mLevel) {
    $sql = "SELECT s.student_no, s.name, s.chinese_name, c.course_name, sec.section_name, sec.section_id, s.student_id
            FROM students s
            JOIN enrollments e ON s.student_id = e.student_id
            JOIN sections sec ON e.section_id = sec.section_id
            JOIN offerings o ON sec.offering_id = o.offering_id
            JOIN courses c ON o.course_id = c.course_id
            WHERE e.enrollment_status = 'active'";
    
    if ($mOffering) $sql .= " AND o.offering_id = " . intval($mOffering);
    if ($mLevel) $sql .= " AND c.level_code = " . $conn->quote($mLevel);
    $sql .= " ORDER BY c.course_name, sec.section_name, s.student_no";
    
    $rows = $conn->query($sql)->fetchAll();
    
    foreach ($rows as $row) {
        $dateCond = '';
        if ($startDate) $dateCond .= " AND class_date >= " . $conn->quote($startDate);
        if ($endDate) $dateCond .= " AND class_date <= " . $conn->quote($endDate);
        
        $stmt = $conn->prepare("SELECT attendance_status, COUNT(*) as cnt FROM attendance 
                                WHERE section_id = ? AND student_id = ? $dateCond
                                GROUP BY attendance_status");
        $stmt->execute([$row['section_id'], $row['student_id']]);
        $stats = [];
        $total = 0;
        foreach ($stmt->fetchAll() as $st) {
            $stats[$st['attendance_status']] = $st['cnt'];
            $total += $st['cnt'];
        }
        $present = ($stats['P'] ?? 0) + ($stats['L'] ?? 0) * 0.5;
        $rate = $total > 0 ? round($present / $total * 100, 1) : 0;
        
        $row['total'] = $total;
        $row['present'] = $stats['P'] ?? 0;
        $row['late'] = $stats['L'] ?? 0;
        $row['absent'] = $stats['A'] ?? 0;
        $row['leave'] = ($stats['E'] ?? 0) + ($stats['O'] ?? 0) + ($stats['S'] ?? 0);
        $row['rate'] = $rate;
        $reportData[] = $row;
    }
}

// 開班列表
$offerings = $conn->query("SELECT o.offering_id, o.semester, c.course_name FROM offerings o JOIN courses c ON o.course_id = c.course_id WHERE o.offering_status = 'active' ORDER BY o.semester DESC, c.course_name")->fetchAll();
$levels = get_levels();
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>出席統計報表 - <?= APP_NAME ?></title>
  <?php include_once "temp_head.php"; ?>
</head>
<body>
  <?php include_once "temp_header.php"; ?>
  <?php include_once "temp_sidebar.php"; ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>出席統計報表</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">出席統計報表</li>
        </ol>
      </nav>
    </div>

    <div class="container-fluid">
      <!-- 篩選條件 -->
      <div class="card mb-4">
        <div class="card-body mt-3">
          <form method="GET" class="row g-3 align-items-end">
            <div class="col-md-3">
              <label class="form-label">課程</label>
              <select name="offering_id" class="form-select">
                <option value="">請選擇</option>
                <?php foreach ($offerings as $o): ?>
                <option value="<?= $o['offering_id'] ?>" <?= $mOffering == $o['offering_id'] ? 'selected' : '' ?>>
                  <?= e($o['course_name']) ?> (<?= e($o['semester']) ?>)
                </option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">程度</label>
              <select name="level_code" class="form-select">
                <option value="">全部</option>
                <?php foreach ($levels as $l): ?>
                <option value="<?= e($l['level_code']) ?>" <?= $mLevel == $l['level_code'] ? 'selected' : '' ?>><?= e($l['level_code']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">開始日期</label>
              <input type="date" name="start_date" class="form-control" value="<?= e($startDate) ?>">
            </div>
            <div class="col-md-2">
              <label class="form-label">結束日期</label>
              <input type="date" name="end_date" class="form-control" value="<?= e($endDate) ?>">
            </div>
            <div class="col-auto">
              <button type="submit" class="btn btn-primary"><i class="bi bi-search me-1"></i>查詢</button>
              <a href="report_attendance.php" class="btn btn-outline-secondary">重設</a>
              <?php if (!empty($reportData)): ?>
              <a href="?<?= http_build_query($_GET) ?>&export=csv" class="btn btn-success">
                <i class="bi bi-download me-1"></i>匯出
              </a>
              <?php endif; ?>
            </div>
          </form>
        </div>
      </div>

      <!-- 報表 -->
      <div class="card">
        <div class="card-header">
          <i class="bi bi-table me-2"></i>出席統計
          <?php if (!empty($reportData)): ?>
          <span class="badge bg-secondary ms-2"><?= count($reportData) ?> 筆</span>
          <?php endif; ?>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-hover mb-0" id="reportTable">
              <thead>
                <tr class="table-primary">
                  <th>學號</th>
                  <th>姓名</th>
                  <th>課程</th>
                  <th>班級</th>
                  <th class="text-center">總堂</th>
                  <th class="text-center">出席</th>
                  <th class="text-center">遲到</th>
                  <th class="text-center">缺席</th>
                  <th class="text-center">請假</th>
                  <th class="text-center">出席率</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($reportData)): ?>
                <tr><td colspan="10" class="text-center text-muted py-4">請選擇篩選條件後查詢</td></tr>
                <?php else: ?>
                <?php foreach ($reportData as $row): ?>
                <tr>
                  <td><?= e($row['student_no']) ?></td>
                  <td><?= e($row['name']) ?><?= $row['chinese_name'] ? ' (' . e($row['chinese_name']) . ')' : '' ?></td>
                  <td><?= e($row['course_name']) ?></td>
                  <td><?= e($row['section_name']) ?></td>
                  <td class="text-center"><?= $row['total'] ?></td>
                  <td class="text-center text-success"><?= $row['present'] ?></td>
                  <td class="text-center text-warning"><?= $row['late'] ?></td>
                  <td class="text-center text-danger"><?= $row['absent'] ?></td>
                  <td class="text-center"><?= $row['leave'] ?></td>
                  <td class="text-center">
                    <span class="badge bg-<?= $row['rate'] >= 80 ? 'success' : ($row['rate'] >= 60 ? 'warning' : 'danger') ?>">
                      <?= $row['rate'] ?>%
                    </span>
                  </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </main>

  <?php include_once "temp_footer.php"; ?>
  <script>
    showSidebar("reports", "report_attendance");
    
    // 初始化 DataTable
    document.addEventListener('DOMContentLoaded', function() {
      if (document.querySelector('#reportTable tbody tr').querySelector('td[colspan]') === null) {
        new simpleDatatables.DataTable('#reportTable', {
          perPage: 20,
          labels: {
            placeholder: "搜尋...",
            perPage: "每頁 {select} 筆",
            noRows: "沒有資料",
            info: "顯示 {start} 到 {end} 筆，共 {rows} 筆"
          }
        });
      }
    });
  </script>
</body>
</html>
