<?php
/**
 * ISLMS - 個人資料
 */
include_once 'src/function.php';
check_login();

$stmt = $conn->prepare("SELECT * FROM users WHERE user_id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf($_POST['csrfToken'] ?? '')) {
        set_flash('error', 'CSRF 驗證失敗');
        redirect('profile.php');
    }
    
    $data = [
        'name' => trim($_POST['name'] ?? ''),
        'name_en' => trim($_POST['name_en'] ?? ''),
        'email' => trim($_POST['email'] ?? ''),
        'phone' => trim($_POST['phone'] ?? '')
    ];
    
    if (empty($data['name'])) {
        set_flash('error', '姓名為必填');
        redirect('profile.php');
    }
    
    $stmt = $conn->prepare("UPDATE users SET name=?, name_en=?, email=?, phone=?, updated_by=? WHERE user_id=?");
    $stmt->execute([$data['name'], $data['name_en'], $data['email'], $data['phone'], $_SESSION['user_account'], $_SESSION['user_id']]);
    
    $_SESSION['user_name'] = $data['name'];
    
    write_log('update', 'users', $_SESSION['user_id'], '更新個人資料');
    set_flash('success', '個人資料已更新');
    redirect('profile.php');
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>個人資料 - <?= APP_NAME ?></title>
  <?php include_once "temp_head.php"; ?>
</head>
<body>
  <?php include_once "temp_header.php"; ?>
  <?php include_once "temp_sidebar.php"; ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>個人資料</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">個人資料</li>
        </ol>
      </nav>
    </div>

    <div class="container-fluid">
      <?php show_flash(); ?>
      
      <div class="row">
        <div class="col-md-8">
          <div class="card">
            <div class="card-body mt-4">
              <form method="post">
                <?= csrf_field() ?>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label">帳號</label>
                    <input type="text" class="form-control" value="<?= e($user['account']) ?>" readonly>
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label">角色</label>
                    <input type="text" class="form-control" value="<?= get_role_name($user['role']) ?>" readonly>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label">中文姓名 <span class="text-danger">*</span></label>
                    <input type="text" name="name" class="form-control" required value="<?= e($user['name']) ?>">
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label">英文姓名</label>
                    <input type="text" name="name_en" class="form-control" value="<?= e($user['name_en']) ?>">
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-6 mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" value="<?= e($user['email']) ?>">
                  </div>
                  <div class="col-md-6 mb-3">
                    <label class="form-label">電話</label>
                    <input type="text" name="phone" class="form-control" value="<?= e($user['phone']) ?>">
                  </div>
                </div>
                <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>儲存變更</button>
              </form>
            </div>
          </div>
        </div>
        
        <div class="col-md-4">
          <div class="card">
            <div class="card-header"><i class="bi bi-info-circle me-2"></i>帳號資訊</div>
            <div class="card-body">
              <p><strong>建立時間：</strong><br><?= format_datetime($user['create_date']) ?></p>
              <p><strong>最後登入：</strong><br><?= $user['last_login_at'] ? format_datetime($user['last_login_at']) : '從未登入' ?></p>
              <hr>
              <a href="password.php" class="btn btn-outline-warning w-100">
                <i class="bi bi-key me-1"></i>變更密碼
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <?php include_once "temp_footer.php"; ?>
</body>
</html>
