<?php
/**
 * ISLMS - 變更密碼
 */
include_once 'src/function.php';
check_login();

$errors = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf($_POST['csrfToken'] ?? '')) {
        $errors[] = 'CSRF 驗證失敗';
    } else {
        $currentPassword = $_POST['current_password'] ?? '';
        $newPassword = $_POST['new_password'] ?? '';
        $confirmPassword = $_POST['confirm_password'] ?? '';
        
        // 驗證目前密碼
        $stmt = $conn->prepare("SELECT password_hash FROM users WHERE user_id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch();
        
        if (!$user || !verify_password($currentPassword, $user['password_hash'])) {
            $errors[] = '目前密碼不正確';
        }
        
        if (empty($newPassword)) {
            $errors[] = '請輸入新密碼';
        } elseif (strlen($newPassword) < 6) {
            $errors[] = '新密碼至少需要 6 個字元';
        }
        
        if ($newPassword !== $confirmPassword) {
            $errors[] = '確認密碼不一致';
        }
        
        if (empty($errors)) {
            $stmt = $conn->prepare("UPDATE users SET password_hash = ? WHERE user_id = ?");
            $stmt->execute([hash_password($newPassword), $_SESSION['user_id']]);
            
            write_log('change_password', 'users', $_SESSION['user_id'], '變更密碼');
            $success = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>變更密碼 - <?= APP_NAME ?></title>
  <?php include_once "temp_head.php"; ?>
</head>
<body>
  <?php include_once "temp_header.php"; ?>
  <?php include_once "temp_sidebar.php"; ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>變更密碼</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">變更密碼</li>
        </ol>
      </nav>
    </div>

    <div class="container-fluid">
      <div class="row justify-content-center">
        <div class="col-md-6">
          <?php if ($success): ?>
          <div class="alert alert-success">
            <i class="bi bi-check-circle me-2"></i>密碼已成功變更！
          </div>
          <?php endif; ?>
          
          <?php if (!empty($errors)): ?>
          <div class="alert alert-danger">
            <ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?></ul>
          </div>
          <?php endif; ?>
          
          <div class="card">
            <div class="card-body mt-4">
              <form method="post">
                <?= csrf_field() ?>
                <div class="mb-3">
                  <label class="form-label">目前密碼 <span class="text-danger">*</span></label>
                  <input type="password" name="current_password" class="form-control" required>
                </div>
                <div class="mb-3">
                  <label class="form-label">新密碼 <span class="text-danger">*</span></label>
                  <input type="password" name="new_password" class="form-control" required minlength="6">
                  <div class="form-text">密碼至少需要 6 個字元</div>
                </div>
                <div class="mb-3">
                  <label class="form-label">確認新密碼 <span class="text-danger">*</span></label>
                  <input type="password" name="confirm_password" class="form-control" required>
                </div>
                <div class="d-flex gap-2">
                  <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>變更密碼</button>
                  <a href="profile.php" class="btn btn-secondary">取消</a>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

  <?php include_once "temp_footer.php"; ?>
</body>
</html>
