<?php
/**
 * ISLMS - 開班詳細
 */
include_once 'src/function.php';
check_staff();

$rid = intval($_GET['id'] ?? 0);
if (!$rid) {
    set_flash('error', '參數錯誤');
    redirect('offerings_list.php');
}

// 取得開班資訊
$stmt = $conn->prepare("SELECT o.*, c.course_name, c.course_name_en, c.level_code, u.name as teacher_name 
                        FROM offerings o
                        LEFT JOIN courses c ON o.course_id = c.course_id
                        LEFT JOIN users u ON o.teacher_id = u.user_id
                        WHERE o.offering_id = ?");
$stmt->execute([$rid]);
$offering = $stmt->fetch();

if (!$offering) {
    set_flash('error', '開班不存在');
    redirect('offerings_list.php');
}

// 取得班級列表
$stmt = $conn->prepare("SELECT s.*, u.name as teacher_name,
                        (SELECT COUNT(*) FROM enrollments e WHERE e.section_id = s.section_id AND e.enrollment_status = 'active') as student_count
                        FROM sections s
                        LEFT JOIN users u ON COALESCE(s.teacher_id, ?) = u.user_id
                        WHERE s.offering_id = ?
                        ORDER BY s.section_name");
$stmt->execute([$offering['teacher_id'], $rid]);
$sections = $stmt->fetchAll();

// 取得未分班學生
$stmt = $conn->prepare("SELECT s.* FROM students s 
                        WHERE s.level_code = ? AND s.status = 1 
                        AND s.student_id NOT IN (
                            SELECT e.student_id FROM enrollments e 
                            JOIN sections sec ON e.section_id = sec.section_id 
                            WHERE sec.offering_id = ? AND e.enrollment_status = 'active'
                        )
                        ORDER BY s.student_no");
$stmt->execute([$offering['level_code'], $rid]);
$unassignedStudents = $stmt->fetchAll();

$teachers = get_teachers();
$st = get_offering_status($offering['offering_status']);
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title><?= e($offering['course_name']) ?> - <?= APP_NAME ?></title>
  <?php include_once "temp_head.php"; ?>
</head>
<body>
  <?php include_once "temp_header.php"; ?>
  <?php include_once "temp_sidebar.php"; ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1><?= e($offering['course_name']) ?></h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item"><a href="offerings_list.php">開班管理</a></li>
          <li class="breadcrumb-item active"><?= e($offering['course_name']) ?></li>
        </ol>
      </nav>
    </div>

    <div class="container-fluid">
      <?php show_flash(); ?>
      
      <!-- 開班資訊 -->
      <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
          <span><i class="bi bi-info-circle me-2"></i>開班資訊</span>
          <div>
            <a href="offerings_edit.php?rid=<?= $rid ?>" class="btn btn-sm btn-outline-primary">
              <i class="bi bi-pencil me-1"></i>編輯
            </a>
            <span class="badge bg-<?= $st['class'] ?> ms-2"><?= $st['name'] ?></span>
          </div>
        </div>
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <table class="table table-borderless mb-0">
                <tr><th width="120">學期</th><td><?= e($offering['semester']) ?></td></tr>
                <tr><th>課程名稱</th><td><?= e($offering['course_name']) ?> <?= $offering['course_name_en'] ? '<br><small class="text-muted">' . e($offering['course_name_en']) . '</small>' : '' ?></td></tr>
                <tr><th>程度</th><td><span class="badge bg-info"><?= e($offering['level_code']) ?></span></td></tr>
                <tr><th>授課教師</th><td><?= e($offering['teacher_name'] ?? '-') ?></td></tr>
              </table>
            </div>
            <div class="col-md-6">
              <table class="table table-borderless mb-0">
                <tr><th width="120">課程期間</th><td><?= format_date($offering['start_date']) ?> ~ <?= format_date($offering['end_date']) ?></td></tr>
                <tr><th>上課時間</th><td><?= e($offering['class_time'] ?: '-') ?></td></tr>
                <tr><th>上課週期</th><td><?= e($offering['schedule'] ?: '-') ?></td></tr>
                <tr><th>教室</th><td><?= e($offering['classroom'] ?: '-') ?></td></tr>
              </table>
            </div>
          </div>
        </div>
      </div>
      
      <!-- 班級管理 -->
      <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
          <span><i class="bi bi-collection me-2"></i>班級列表</span>
          <div>
            <?php if (!empty($unassignedStudents)): ?>
            <button type="button" class="btn btn-sm btn-success" onclick="autoAssign()">
              <i class="bi bi-magic me-1"></i>自動編班 (<?= count($unassignedStudents) ?>人待分配)
            </button>
            <?php endif; ?>
            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addSectionModal">
              <i class="bi bi-plus-circle me-1"></i>新增班級
            </button>
          </div>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-hover mb-0">
              <thead>
                <tr class="table-primary">
                  <th>班級名稱</th>
                  <th>授課教師</th>
                  <th>教室</th>
                  <th class="text-center">學生人數</th>
                  <th class="text-center">上限</th>
                  <th width="150">操作</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($sections)): ?>
                <tr><td colspan="6" class="text-center text-muted py-4">尚未建立班級</td></tr>
                <?php else: ?>
                <?php foreach ($sections as $sec): ?>
                <tr>
                  <td><a href="sections_view.php?id=<?= $sec['section_id'] ?>" class="fw-bold"><?= e($sec['section_name']) ?></a></td>
                  <td><?= e($sec['teacher_name'] ?? $offering['teacher_name'] ?? '-') ?></td>
                  <td><?= e($sec['classroom'] ?? $offering['classroom'] ?? '-') ?></td>
                  <td class="text-center"><span class="badge bg-primary"><?= $sec['student_count'] ?></span></td>
                  <td class="text-center"><?= $sec['max_students'] ?? $offering['max_students_per_section'] ?></td>
                  <td>
                    <a href="sections_view.php?id=<?= $sec['section_id'] ?>" class="btn btn-sm btn-outline-info">查看</a>
                    <a href="attendance_entry.php?section_id=<?= $sec['section_id'] ?>" class="btn btn-sm btn-outline-success">點名</a>
                  </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      
      <!-- 未分班學生 -->
      <?php if (!empty($unassignedStudents)): ?>
      <div class="card">
        <div class="card-header">
          <i class="bi bi-person-x me-2"></i>未分班學生 (程度: <?= e($offering['level_code']) ?>)
          <span class="badge bg-warning ms-2"><?= count($unassignedStudents) ?> 人</span>
        </div>
        <div class="card-body p-0">
          <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
            <table class="table table-sm mb-0">
              <thead class="sticky-top bg-white">
                <tr>
                  <th>學號</th>
                  <th>姓名</th>
                  <th>國籍</th>
                  <th>類型</th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($unassignedStudents as $s): ?>
                <tr>
                  <td><?= e($s['student_no']) ?></td>
                  <td><?= e($s['name']) ?> <?= $s['chinese_name'] ? '(' . e($s['chinese_name']) . ')' : '' ?></td>
                  <td><?= e($s['nationality']) ?></td>
                  <td><span class="badge bg-<?= $s['student_type'] == 'degree' ? 'primary' : 'success' ?>"><?= $s['student_type'] == 'degree' ? '學位生' : '交換生' ?></span></td>
                </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
      <?php endif; ?>
    </div>
  </main>

  <!-- 新增班級 Modal -->
  <div class="modal fade" id="addSectionModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">新增班級</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <form id="addSectionForm">
          <div class="modal-body">
            <div class="mb-3">
              <label class="form-label">班級名稱 <span class="text-danger">*</span></label>
              <input type="text" name="section_name" class="form-control" required placeholder="例：A班">
            </div>
            <div class="mb-3">
              <label class="form-label">授課教師 (留空使用開班設定)</label>
              <select name="teacher_id" class="form-select">
                <option value="">使用開班設定</option>
                <?php foreach ($teachers as $t): ?>
                <option value="<?= $t['user_id'] ?>"><?= e($t['name']) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="mb-3">
              <label class="form-label">教室</label>
              <input type="text" name="classroom" class="form-control" placeholder="留空使用開班設定">
            </div>
            <div class="mb-3">
              <label class="form-label">人數上限</label>
              <input type="number" name="max_students" class="form-control" min="1" max="50" value="<?= $offering['max_students_per_section'] ?>">
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
            <button type="submit" class="btn btn-primary">新增</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <?php include_once "temp_footer.php"; ?>

  <script>
    showSidebar("offerings", "offerings_list");
    
    const offeringId = <?= $rid ?>;

    document.getElementById('addSectionForm').addEventListener('submit', function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      formData.append('action', 'create_section');
      formData.append('offering_id', offeringId);
      formData.append('csrfToken', csrfToken);
      
      fetch('api/sections_api.php', { method: 'POST', body: formData })
        .then(r => r.json())
        .then(res => {
          if (res.success) location.reload();
          else alert(res.message);
        });
    });

    function autoAssign() {
      if (!confirm('確定要自動編班嗎？\n系統將依據每班上限 <?= $offering['max_students_per_section'] ?> 人自動分配學生。')) return;
      
      ajaxPost('api/sections_api.php', {action: 'auto_assign', offering_id: offeringId}, function(res) {
        if (res.success) {
          showToast(res.message);
          location.reload();
        } else {
          alert(res.message);
        }
      });
    }
  </script>
</body>
</html>
