<?php
/**
 * ISLMS - 開班管理
 */
include_once 'src/function.php';
check_staff();

$mSemester = $_REQUEST['mSemester'] ?? '';
$mStatus = $_REQUEST['mStatus'] ?? '';

// 查詢資料
$sql = "SELECT o.*, c.course_name, c.level_code, u.name as teacher_name,
               (SELECT COUNT(*) FROM sections s WHERE s.offering_id = o.offering_id) as section_count,
               (SELECT COUNT(*) FROM enrollments e JOIN sections s ON e.section_id = s.section_id WHERE s.offering_id = o.offering_id AND e.enrollment_status = 'active') as student_count
        FROM offerings o
        LEFT JOIN courses c ON o.course_id = c.course_id
        LEFT JOIN users u ON o.teacher_id = u.user_id
        WHERE 1=1";

if (!empty($mSemester)) $sql .= " AND o.semester = " . $conn->quote($mSemester);
if (!empty($mStatus)) $sql .= " AND o.offering_status = " . $conn->quote($mStatus);

$sql .= " ORDER BY o.semester DESC, c.course_name";
$data_list = $conn->query($sql)->fetchAll();

// 學期列表
$semesters = $conn->query("SELECT DISTINCT semester FROM offerings ORDER BY semester DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>開班管理 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>開班管理</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active">開班管理</li>
                </ol>
            </nav>
        </div>

        <div class="container-fluid">
            <?php show_flash(); ?>
            
            <div class="card mb-4">
                <div class="card-body mt-3">
                    <form method="GET" id="searchForm" class="d-flex align-items-center flex-wrap gap-2">
                        <select class="form-select" name="mSemester" style="width: 150px;" onchange="this.form.submit();">
                            <option value="">全部學期</option>
                            <?php foreach ($semesters as $s): ?>
                            <option value="<?= e($s['semester']) ?>" <?= $mSemester == $s['semester'] ? 'selected' : '' ?>><?= e($s['semester']) ?></option>
                            <?php endforeach; ?>
                        </select>
                        <select class="form-select" name="mStatus" style="width: 150px;" onchange="this.form.submit();">
                            <option value="">全部狀態</option>
                            <option value="draft" <?= $mStatus == 'draft' ? 'selected' : '' ?>>草稿</option>
                            <option value="active" <?= $mStatus == 'active' ? 'selected' : '' ?>>進行中</option>
                            <option value="closed" <?= $mStatus == 'closed' ? 'selected' : '' ?>>已結束</option>
                        </select>
                        <button type="button" class="btn btn-outline-secondary" onclick="location.href='offerings_list.php'">
                            <i class="bi bi-arrow-counterclockwise"></i> 重設
                        </button>
                        <a href="offerings_edit.php" class="btn btn-primary">
                            <i class="bi bi-plus-circle"></i> 新增開班
                        </a>
                    </form>
                </div>
            </div>

            <div class="card">
                <div class="card-body mt-4">
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered">
                            <thead>
                                <tr class="table-primary">
                                    <th style="width:60px;"></th>
                                    <th>學期</th>
                                    <th>課程名稱</th>
                                    <th>程度</th>
                                    <th>授課教師</th>
                                    <th>班級/學生</th>
                                    <th>課程期間</th>
                                    <th>狀態</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (count($data_list) > 0): ?>
                                <?php foreach ($data_list as $data): ?>
                                <?php $st = get_offering_status($data['offering_status']); ?>
                                <tr>
                                    <td>
                                        <a href="offerings_view.php?id=<?= $data['offering_id'] ?>" class="btn btn-sm btn-outline-info" title="查看">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    </td>
                                    <td><?= e($data['semester']) ?></td>
                                    <td>
                                        <a href="offerings_view.php?id=<?= $data['offering_id'] ?>" class="text-decoration-none fw-bold">
                                            <?= e($data['course_name']) ?>
                                        </a>
                                    </td>
                                    <td><span class="badge bg-info"><?= e($data['level_code']) ?></span></td>
                                    <td><?= e($data['teacher_name'] ?? '-') ?></td>
                                    <td>
                                        <span class="badge bg-secondary"><?= $data['section_count'] ?> 班</span>
                                        <span class="badge bg-primary"><?= $data['student_count'] ?> 人</span>
                                    </td>
                                    <td><small><?= format_date($data['start_date']) ?> ~ <?= format_date($data['end_date']) ?></small></td>
                                    <td><span class="badge bg-<?= $st['class'] ?>"><?= $st['name'] ?></span></td>
                                </tr>
                                <?php endforeach; ?>
                                <?php else: ?>
                                <tr><td colspan="8" class="text-center text-muted py-4">目前沒有資料</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php include_once "temp_footer.php"; ?>
    <script>showSidebar("offerings", "offerings_list");</script>
</body>
</html>
