<?php
/**
 * ISLMS - 開班編輯
 */
include_once 'src/function.php';
check_staff();

$rid = $_GET['rid'] ?? $_GET['id'] ?? 0;
$isEdit = $rid > 0;
$data = [];
$errors = [];

if ($isEdit) {
    $stmt = $conn->prepare("SELECT * FROM offerings WHERE offering_id = ?");
    $stmt->execute([$rid]);
    $data = $stmt->fetch();
    if (!$data) {
        set_flash('error', '開班不存在');
        redirect('offerings_list.php');
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf($_POST['csrfToken'] ?? '')) $errors[] = 'CSRF 驗證失敗';
    
    $postData = [
        'course_id' => intval($_POST['course_id'] ?? 0),
        'semester' => trim($_POST['semester'] ?? ''),
        'teacher_id' => intval($_POST['teacher_id'] ?? 0) ?: null,
        'classroom' => trim($_POST['classroom'] ?? ''),
        'start_date' => $_POST['start_date'] ?? '',
        'end_date' => $_POST['end_date'] ?? '',
        'class_time' => trim($_POST['class_time'] ?? ''),
        'schedule' => trim($_POST['schedule'] ?? ''),
        'hours_per_week' => floatval($_POST['hours_per_week'] ?? 0) ?: null,
        'total_hours' => floatval($_POST['total_hours'] ?? 0) ?: null,
        'max_students_per_section' => intval($_POST['max_students_per_section'] ?? 12),
        'offering_status' => $_POST['offering_status'] ?? 'draft',
        'note' => trim($_POST['note'] ?? '')
    ];
    
    if (!$postData['course_id']) $errors[] = '請選擇課程';
    if (empty($postData['semester'])) $errors[] = '學期為必填';
    if (empty($postData['start_date'])) $errors[] = '開課日期為必填';
    if (empty($postData['end_date'])) $errors[] = '結課日期為必填';
    
    if (empty($errors)) {
        if ($isEdit) {
            $sql = "UPDATE offerings SET course_id=?, semester=?, teacher_id=?, classroom=?, start_date=?, end_date=?, class_time=?, schedule=?, hours_per_week=?, total_hours=?, max_students_per_section=?, offering_status=?, note=?, updated_by=? WHERE offering_id=?";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                $postData['course_id'], $postData['semester'], $postData['teacher_id'], $postData['classroom'],
                $postData['start_date'], $postData['end_date'], $postData['class_time'], $postData['schedule'],
                $postData['hours_per_week'], $postData['total_hours'], $postData['max_students_per_section'],
                $postData['offering_status'], $postData['note'], $_SESSION['user_account'], $rid
            ]);
            write_log('update', 'offerings', $rid, '更新開班');
            set_flash('success', '開班已更新');
        } else {
            $sql = "INSERT INTO offerings (course_id, semester, teacher_id, classroom, start_date, end_date, class_time, schedule, hours_per_week, total_hours, max_students_per_section, offering_status, note, created_by) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([
                $postData['course_id'], $postData['semester'], $postData['teacher_id'], $postData['classroom'],
                $postData['start_date'], $postData['end_date'], $postData['class_time'], $postData['schedule'],
                $postData['hours_per_week'], $postData['total_hours'], $postData['max_students_per_section'],
                $postData['offering_status'], $postData['note'], $_SESSION['user_account']
            ]);
            write_log('create', 'offerings', $conn->lastInsertId(), '新增開班');
            set_flash('success', '開班已新增');
        }
        redirect('offerings_list.php');
    }
    $data = array_merge($data, $postData);
}

$courses = get_courses();
$teachers = get_teachers();
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title><?= $isEdit ? '編輯' : '新增' ?>開班 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1><?= $isEdit ? '編輯' : '新增' ?>開班</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item"><a href="offerings_list.php">開班管理</a></li>
                    <li class="breadcrumb-item active"><?= $isEdit ? '編輯' : '新增' ?>開班</li>
                </ol>
            </nav>
        </div>

        <div class="container-fluid">
            <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
                <ul class="mb-0"><?php foreach ($errors as $err): ?><li><?= e($err) ?></li><?php endforeach; ?></ul>
            </div>
            <?php endif; ?>

            <div class="card">
                <div class="card-body mt-4">
                    <form method="post">
                        <?= csrf_field() ?>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">課程 <span class="text-danger">*</span></label>
                                <select name="course_id" class="form-select" required>
                                    <option value="">請選擇課程</option>
                                    <?php foreach ($courses as $c): ?>
                                    <option value="<?= $c['course_id'] ?>" <?= ($data['course_id'] ?? '') == $c['course_id'] ? 'selected' : '' ?>>
                                        <?= e($c['course_name']) ?> (<?= e($c['level_code']) ?>)
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">學期 <span class="text-danger">*</span></label>
                                <input type="text" name="semester" class="form-control" required placeholder="例：114-1" value="<?= e($data['semester'] ?? '') ?>">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">狀態</label>
                                <select name="offering_status" class="form-select">
                                    <option value="draft" <?= ($data['offering_status'] ?? '') == 'draft' ? 'selected' : '' ?>>草稿</option>
                                    <option value="active" <?= ($data['offering_status'] ?? '') == 'active' ? 'selected' : '' ?>>進行中</option>
                                    <option value="closed" <?= ($data['offering_status'] ?? '') == 'closed' ? 'selected' : '' ?>>已結束</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">授課教師</label>
                                <select name="teacher_id" class="form-select">
                                    <option value="">請選擇</option>
                                    <?php foreach ($teachers as $t): ?>
                                    <option value="<?= $t['user_id'] ?>" <?= ($data['teacher_id'] ?? '') == $t['user_id'] ? 'selected' : '' ?>><?= e($t['name']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">教室</label>
                                <input type="text" name="classroom" class="form-control" value="<?= e($data['classroom'] ?? '') ?>">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label class="form-label">每班人數上限</label>
                                <input type="number" name="max_students_per_section" class="form-control" min="1" max="50" value="<?= e($data['max_students_per_section'] ?? 12) ?>">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">開課日期 <span class="text-danger">*</span></label>
                                <input type="date" name="start_date" class="form-control" required value="<?= e($data['start_date'] ?? '') ?>">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">結課日期 <span class="text-danger">*</span></label>
                                <input type="date" name="end_date" class="form-control" required value="<?= e($data['end_date'] ?? '') ?>">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">上課時間</label>
                                <input type="text" name="class_time" class="form-control" placeholder="09:10-12:00" value="<?= e($data['class_time'] ?? '') ?>">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">上課週期</label>
                                <input type="text" name="schedule" class="form-control" placeholder="週二、四" value="<?= e($data['schedule'] ?? '') ?>">
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">每週時數</label>
                                <input type="number" name="hours_per_week" class="form-control" step="0.5" value="<?= e($data['hours_per_week'] ?? '') ?>">
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">總時數</label>
                                <input type="number" name="total_hours" class="form-control" step="0.5" value="<?= e($data['total_hours'] ?? '') ?>">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">備註</label>
                            <textarea name="note" class="form-control" rows="2"><?= e($data['note'] ?? '') ?></textarea>
                        </div>
                        
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>儲存</button>
                            <a href="offerings_list.php" class="btn btn-secondary">取消</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </main>

    <?php include_once "temp_footer.php"; ?>
    <script>showSidebar("offerings", "offerings_edit");</script>
</body>
</html>
