<?php
/**
 * ISLMS - 系統日誌
 */
include_once 'src/function.php';
check_admin();

$mAction = $_REQUEST['action_type'] ?? '';
$startDate = $_REQUEST['start_date'] ?? date('Y-m-d', strtotime('-7 days'));
$endDate = $_REQUEST['end_date'] ?? date('Y-m-d');

// 分頁
$itemsPerPage = 20;
$page = max(1, intval($_GET['page'] ?? 1));

// 計算總筆數
$sqlTotal = "SELECT COUNT(*) FROM audit_logs WHERE created_at BETWEEN ? AND ?";
$params = [$startDate . ' 00:00:00', $endDate . ' 23:59:59'];
if ($mAction) {
    $sqlTotal .= " AND action = ?";
    $params[] = $mAction;
}
$stmt = $conn->prepare($sqlTotal);
$stmt->execute($params);
$totalItems = $stmt->fetchColumn();
$totalPages = ceil($totalItems / $itemsPerPage);
$offset = ($page - 1) * $itemsPerPage;

// 查詢日誌
$sql = "SELECT l.*, u.name as user_name FROM audit_logs l LEFT JOIN users u ON l.user_id = u.user_id WHERE l.created_at BETWEEN ? AND ?";
$params = [$startDate . ' 00:00:00', $endDate . ' 23:59:59'];
if ($mAction) {
    $sql .= " AND l.action = ?";
    $params[] = $mAction;
}
$sql .= " ORDER BY l.created_at DESC LIMIT $itemsPerPage OFFSET $offset";

$stmt = $conn->prepare($sql);
$stmt->execute($params);
$logs = $stmt->fetchAll();

// 操作類型列表
$actions = $conn->query("SELECT DISTINCT action FROM audit_logs ORDER BY action")->fetchAll(PDO::FETCH_COLUMN);
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>系統日誌 - <?= APP_NAME ?></title>
  <?php include_once "temp_head.php"; ?>
</head>
<body>
  <?php include_once "temp_header.php"; ?>
  <?php include_once "temp_sidebar.php"; ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>系統日誌</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">系統日誌</li>
        </ol>
      </nav>
    </div>

    <div class="container-fluid">
      <div class="card mb-4">
        <div class="card-body mt-3">
          <form method="GET" class="row g-3 align-items-end">
            <div class="col-md-2">
              <label class="form-label">操作類型</label>
              <select name="action_type" class="form-select">
                <option value="">全部</option>
                <?php foreach ($actions as $a): ?>
                <option value="<?= e($a) ?>" <?= $mAction == $a ? 'selected' : '' ?>><?= e($a) ?></option>
                <?php endforeach; ?>
              </select>
            </div>
            <div class="col-md-2">
              <label class="form-label">開始日期</label>
              <input type="date" name="start_date" class="form-control" value="<?= e($startDate) ?>">
            </div>
            <div class="col-md-2">
              <label class="form-label">結束日期</label>
              <input type="date" name="end_date" class="form-control" value="<?= e($endDate) ?>">
            </div>
            <div class="col-auto">
              <button type="submit" class="btn btn-primary"><i class="bi bi-search me-1"></i>查詢</button>
              <a href="logs_list.php" class="btn btn-outline-secondary">重設</a>
            </div>
          </form>
        </div>
      </div>

      <div class="card">
        <div class="card-body mt-4">
          <div class="table-responsive">
            <table class="table table-hover table-bordered">
              <thead>
                <tr class="table-primary">
                  <th style="width:150px;">時間</th>
                  <th style="width:100px;">操作者</th>
                  <th style="width:120px;">操作類型</th>
                  <th style="width:100px;">資料表</th>
                  <th>說明</th>
                  <th style="width:120px;">IP</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($logs)): ?>
                <tr><td colspan="6" class="text-center text-muted py-4">沒有日誌記錄</td></tr>
                <?php else: ?>
                <?php foreach ($logs as $log): ?>
                <tr>
                  <td><small><?= format_datetime($log['created_at'], 'Y-m-d H:i:s') ?></small></td>
                  <td><?= e($log['user_name'] ?? '-') ?></td>
                  <td><span class="badge bg-secondary"><?= e($log['action']) ?></span></td>
                  <td><?= e($log['table_name'] ?? '-') ?></td>
                  <td><small><?= e($log['description'] ?? '-') ?></small></td>
                  <td><small class="text-muted"><?= e($log['ip_address']) ?></small></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>

          <!-- 分頁 -->
          <?php if ($totalPages > 1): ?>
          <div class="d-flex justify-content-center mt-4">
            <nav>
              <ul class="pagination">
                <?php if ($page > 1): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $page - 1 ?>&action_type=<?= e($mAction) ?>&start_date=<?= e($startDate) ?>&end_date=<?= e($endDate) ?>">&laquo;</a></li>
                <?php endif; ?>
                
                <?php for ($i = max(1, $page - 2); $i <= min($totalPages, $page + 2); $i++): ?>
                <li class="page-item <?= $i == $page ? 'active' : '' ?>">
                  <a class="page-link" href="?page=<?= $i ?>&action_type=<?= e($mAction) ?>&start_date=<?= e($startDate) ?>&end_date=<?= e($endDate) ?>"><?= $i ?></a>
                </li>
                <?php endfor; ?>
                
                <?php if ($page < $totalPages): ?>
                <li class="page-item"><a class="page-link" href="?page=<?= $page + 1 ?>&action_type=<?= e($mAction) ?>&start_date=<?= e($startDate) ?>&end_date=<?= e($endDate) ?>">&raquo;</a></li>
                <?php endif; ?>
              </ul>
            </nav>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </main>

  <?php include_once "temp_footer.php"; ?>
  <script>showSidebar("system", "logs_list");</script>
</body>
</html>
