<?php
/**
 * ISLMS - 登入頁面
 */
include_once 'src/globarvar.php';

$error = '';

// 已登入則跳轉
if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

// 處理登入
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $account = trim($_POST['account'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($account) || empty($password)) {
        $error = '請輸入帳號和密碼';
    } else {
        $stmt = $conn->prepare("SELECT * FROM users WHERE account = ? AND status = 1");
        $stmt->execute([$account]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password_hash'])) {
            // 登入成功
            $_SESSION['user_id'] = $user['user_id'];
            $_SESSION['user_account'] = $user['account'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_role'] = $user['role'];
            
            // 更新最後登入時間
            $stmt = $conn->prepare("UPDATE users SET last_login_at = NOW() WHERE user_id = ?");
            $stmt->execute([$user['user_id']]);
            
            // 寫入日誌
            $stmt = $conn->prepare("INSERT INTO audit_logs (user_id, action, description, ip_address, created_at) VALUES (?, 'login', '使用者登入', ?, NOW())");
            $stmt->execute([$user['user_id'], $client_ip]);
            
            header('Location: index.php');
            exit;
        } else {
            $error = '帳號或密碼錯誤';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>登入 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        .login-card {
            max-width: 400px;
            margin: 0 auto;
            margin-top: 10vh;
        }
    </style>
</head>
<body>
    <main>
        <div class="container">
            <div class="login-card">
                <div class="card shadow-lg">
                    <div class="card-body p-5">
                        <div class="text-center mb-4">
                            <h3 class="text-primary"><?= APP_NAME ?></h3>
                            <p class="text-muted"><?= APP_NAME_EN ?></p>
                        </div>
                        
                        <?php if ($error): ?>
                        <div class="alert alert-danger"><?= e($error) ?></div>
                        <?php endif; ?>
                        
                        <form method="post">
                            <input type="hidden" name="csrfToken" value="<?= $csrfToken ?>">
                            
                            <div class="mb-3">
                                <label class="form-label">帳號</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-person"></i></span>
                                    <input type="text" name="account" class="form-control" placeholder="請輸入帳號" required autofocus
                                           value="<?= e($_POST['account'] ?? '') ?>">
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <label class="form-label">密碼</label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="bi bi-lock"></i></span>
                                    <input type="password" name="password" class="form-control" placeholder="請輸入密碼" required>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary w-100 py-2">
                                <i class="bi bi-box-arrow-in-right me-2"></i>登入
                            </button>
                        </form>
                    </div>
                </div>
                
                <div class="text-center mt-3">
                    <small class="text-white">Version <?= APP_VERSION ?></small>
                </div>
            </div>
        </div>
    </main>
    
    <script src="assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
</body>
</html>
