<?php
/**
 * ISLMS - 儀表板
 */
include_once 'src/function.php';
check_login();

// 統計資料
$stats = [];

// 學生總數
$stmt = $conn->query("SELECT COUNT(*) FROM students WHERE status = 1");
$stats['students'] = $stmt->fetchColumn();

// 進行中開班數
$stmt = $conn->query("SELECT COUNT(*) FROM offerings WHERE offering_status = 'active'");
$stats['offerings'] = $stmt->fetchColumn();

// 班級數
$stmt = $conn->query("SELECT COUNT(*) FROM sections s JOIN offerings o ON s.offering_id = o.offering_id WHERE o.offering_status = 'active'");
$stats['sections'] = $stmt->fetchColumn();

// 在學人數
$stmt = $conn->query("SELECT COUNT(*) FROM enrollments WHERE enrollment_status = 'active'");
$stats['enrollments'] = $stmt->fetchColumn();

// 程度分布統計
$stmt = $conn->query("SELECT level_code, COUNT(*) as cnt FROM students WHERE status = 1 GROUP BY level_code ORDER BY level_code");
$levelStats = $stmt->fetchAll();

// 進行中的開班列表
$sql = "SELECT o.*, c.course_name, c.level_code, u.name as teacher_name,
               (SELECT COUNT(*) FROM sections s WHERE s.offering_id = o.offering_id) as section_count,
               (SELECT COUNT(*) FROM enrollments e JOIN sections s ON e.section_id = s.section_id WHERE s.offering_id = o.offering_id AND e.enrollment_status = 'active') as student_count
        FROM offerings o
        LEFT JOIN courses c ON o.course_id = c.course_id
        LEFT JOIN users u ON o.teacher_id = u.user_id
        WHERE o.offering_status = 'active'
        ORDER BY o.start_date DESC
        LIMIT 5";
$offerings = $conn->query($sql)->fetchAll();

// 教師專用：我的班級
$myClasses = [];
if ($_SESSION['user_role'] === 'teacher') {
    $stmt = $conn->prepare("SELECT s.*, o.semester, c.course_name, c.level_code 
                            FROM sections s
                            JOIN offerings o ON s.offering_id = o.offering_id
                            JOIN courses c ON o.course_id = c.course_id
                            WHERE (s.teacher_id = ? OR o.teacher_id = ?) AND o.offering_status = 'active'
                            ORDER BY c.course_name");
    $stmt->execute([$_SESSION['user_id'], $_SESSION['user_id']]);
    $myClasses = $stmt->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>儀表板 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>儀表板</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active">儀表板</li>
                </ol>
            </nav>
        </div>

        <section class="section dashboard">
            <?php show_flash(); ?>
            
            <!-- 統計卡片 -->
            <div class="row">
                <div class="col-xxl-3 col-md-6">
                    <div class="card info-card sales-card">
                        <div class="card-body">
                            <h5 class="card-title">學生總數</h5>
                            <div class="d-flex align-items-center">
                                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-people"></i>
                                </div>
                                <div class="ps-3">
                                    <h6><?= number_format($stats['students']) ?></h6>
                                    <span class="text-muted small">位學生</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-3 col-md-6">
                    <div class="card info-card revenue-card">
                        <div class="card-body">
                            <h5 class="card-title">進行中開班</h5>
                            <div class="d-flex align-items-center">
                                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-calendar-check"></i>
                                </div>
                                <div class="ps-3">
                                    <h6><?= number_format($stats['offerings']) ?></h6>
                                    <span class="text-muted small">門課程</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-3 col-md-6">
                    <div class="card info-card customers-card">
                        <div class="card-body">
                            <h5 class="card-title">班級數</h5>
                            <div class="d-flex align-items-center">
                                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-collection"></i>
                                </div>
                                <div class="ps-3">
                                    <h6><?= number_format($stats['sections']) ?></h6>
                                    <span class="text-muted small">個班級</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xxl-3 col-md-6">
                    <div class="card info-card sales-card">
                        <div class="card-body">
                            <h5 class="card-title">在學人數</h5>
                            <div class="d-flex align-items-center">
                                <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                    <i class="bi bi-person-check"></i>
                                </div>
                                <div class="ps-3">
                                    <h6><?= number_format($stats['enrollments']) ?></h6>
                                    <span class="text-muted small">人選課</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- 程度分布圖 -->
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">學生程度分布</h5>
                            <div id="levelChart" style="min-height: 300px;"></div>
                        </div>
                    </div>
                </div>

                <!-- 快捷操作 -->
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">快捷操作</h5>
                            <div class="row g-3">
                                <?php if (has_role(['admin', 'staff'])): ?>
                                <div class="col-6">
                                    <a href="offerings_edit.php" class="btn btn-primary w-100 py-3">
                                        <i class="bi bi-plus-circle fs-4 d-block mb-2"></i>新增開班
                                    </a>
                                </div>
                                <div class="col-6">
                                    <a href="students_list.php" class="btn btn-success w-100 py-3">
                                        <i class="bi bi-people fs-4 d-block mb-2"></i>學生管理
                                    </a>
                                </div>
                                <?php endif; ?>
                                <div class="col-6">
                                    <a href="attendance_list.php" class="btn btn-info w-100 py-3">
                                        <i class="bi bi-clipboard-check fs-4 d-block mb-2"></i>點名作業
                                    </a>
                                </div>
                                <div class="col-6">
                                    <a href="grades_list.php" class="btn btn-warning w-100 py-3">
                                        <i class="bi bi-journal-text fs-4 d-block mb-2"></i>成績輸入
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if ($_SESSION['user_role'] === 'teacher' && !empty($myClasses)): ?>
                    <!-- 教師：我的班級 -->
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">我的班級</h5>
                            <ul class="list-group">
                                <?php foreach ($myClasses as $cls): ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <div>
                                        <strong><?= e($cls['course_name']) ?></strong>
                                        <span class="badge bg-info ms-2"><?= e($cls['level_code']) ?></span>
                                        <br><small class="text-muted"><?= e($cls['section_name']) ?></small>
                                    </div>
                                    <div>
                                        <a href="attendance_entry.php?section_id=<?= $cls['section_id'] ?>" class="btn btn-sm btn-outline-primary me-1">點名</a>
                                        <a href="grades_entry.php?section_id=<?= $cls['section_id'] ?>" class="btn btn-sm btn-outline-warning">成績</a>
                                    </div>
                                </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- 進行中開班 -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">進行中開班</h5>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr class="table-primary">
                                            <th>學期</th>
                                            <th>課程名稱</th>
                                            <th>程度</th>
                                            <th>授課教師</th>
                                            <th>班級數</th>
                                            <th>學生數</th>
                                            <th>課程期間</th>
                                            <th>操作</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (empty($offerings)): ?>
                                        <tr><td colspan="8" class="text-center text-muted">目前沒有進行中的開班</td></tr>
                                        <?php else: ?>
                                        <?php foreach ($offerings as $o): ?>
                                        <tr>
                                            <td><?= e($o['semester']) ?></td>
                                            <td><a href="offerings_view.php?id=<?= $o['offering_id'] ?>"><?= e($o['course_name']) ?></a></td>
                                            <td><span class="badge bg-info"><?= e($o['level_code']) ?></span></td>
                                            <td><?= e($o['teacher_name'] ?? '-') ?></td>
                                            <td><span class="badge bg-secondary"><?= $o['section_count'] ?></span></td>
                                            <td><span class="badge bg-primary"><?= $o['student_count'] ?></span></td>
                                            <td><small><?= format_date($o['start_date']) ?> ~ <?= format_date($o['end_date']) ?></small></td>
                                            <td>
                                                <a href="offerings_view.php?id=<?= $o['offering_id'] ?>" class="btn btn-sm btn-outline-info">查看</a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include_once "temp_footer.php"; ?>

    <script>
        // 程度分布圖
        document.addEventListener("DOMContentLoaded", () => {
            const levelData = <?= json_encode($levelStats) ?>;
            
            if (levelData.length > 0) {
                new ApexCharts(document.querySelector("#levelChart"), {
                    series: levelData.map(item => item.cnt),
                    chart: {
                        type: 'pie',
                        height: 300
                    },
                    labels: levelData.map(item => item.level_code),
                    colors: ['#4154f1', '#2eca6a', '#ff771d', '#6c757d', '#17a2b8', '#dc3545', '#ffc107', '#28a745'],
                    legend: {
                        position: 'bottom'
                    }
                }).render();
            } else {
                document.querySelector("#levelChart").innerHTML = '<div class="text-center text-muted py-5">尚無資料</div>';
            }
        });
    </script>
</body>
</html>
