<?php
/**
 * ISLMS - 成績管理
 */
include_once 'src/function.php';
check_login();

// 取得班級列表
if ($_SESSION['user_role'] === 'teacher') {
    $stmt = $conn->prepare("SELECT s.*, o.semester, c.course_name, c.level_code 
                            FROM sections s
                            JOIN offerings o ON s.offering_id = o.offering_id
                            JOIN courses c ON o.course_id = c.course_id
                            WHERE (s.teacher_id = ? OR o.teacher_id = ?) AND o.offering_status = 'active'
                            ORDER BY c.course_name");
    $stmt->execute([$_SESSION['user_id'], $_SESSION['user_id']]);
    $sections = $stmt->fetchAll();
} else {
    $sql = "SELECT s.*, o.semester, c.course_name, c.level_code 
            FROM sections s
            JOIN offerings o ON s.offering_id = o.offering_id
            JOIN courses c ON o.course_id = c.course_id
            WHERE o.offering_status = 'active' AND s.section_status = 'active'
            ORDER BY c.course_name, s.section_name";
    $sections = $conn->query($sql)->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <title>成績管理 - <?= APP_NAME ?></title>
    <?php include_once "temp_head.php"; ?>
</head>
<body>
    <?php include_once "temp_header.php"; ?>
    <?php include_once "temp_sidebar.php"; ?>

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>成績管理</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                    <li class="breadcrumb-item active">成績管理</li>
                </ol>
            </nav>
        </div>

        <div class="container-fluid">
            <?php show_flash(); ?>
            
            <div class="alert alert-info">
                <i class="bi bi-info-circle me-2"></i>請選擇要輸入成績的班級
            </div>
            
            <div class="row">
                <?php if (empty($sections)): ?>
                <div class="col-12">
                    <div class="card">
                        <div class="card-body text-center text-muted py-5">
                            <i class="bi bi-inbox fs-1 mb-3 d-block"></i>
                            目前沒有可管理的班級
                        </div>
                    </div>
                </div>
                <?php else: ?>
                <?php foreach ($sections as $s): ?>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h5 class="card-title"><?= e($s['course_name']) ?></h5>
                            <h6 class="card-subtitle mb-2 text-muted"><?= e($s['section_name']) ?></h6>
                            <p class="card-text">
                                <span class="badge bg-info"><?= e($s['level_code']) ?></span>
                                <span class="badge bg-secondary"><?= $s['current_count'] ?> 人</span>
                            </p>
                        </div>
                        <div class="card-footer bg-transparent">
                            <a href="grades_entry.php?section_id=<?= $s['section_id'] ?>" class="btn btn-warning btn-sm w-100">
                                <i class="bi bi-journal-text me-1"></i>輸入成績
                            </a>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </main>

    <?php include_once "temp_footer.php"; ?>
    <script>showSidebar("grades", "grades_list");</script>
</body>
</html>
