<?php
/**
 * ISLMS - 課程設定
 */
include_once 'src/function.php';
check_admin();

$msearchKey = $_REQUEST['mkey'] ?? '';
$mkey = '%' . $msearchKey . '%';

// 查詢課程
$sql = "SELECT c.*, l.level_name FROM courses c LEFT JOIN levels l ON c.level_code = l.level_code WHERE c.status = 1 AND (c.course_code LIKE ? OR c.course_name LIKE ?) ORDER BY c.level_code, c.course_code";
$stmt = $conn->prepare($sql);
$stmt->execute([$mkey, $mkey]);
$courses = $stmt->fetchAll();

$levels = get_levels();
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>課程設定 - <?= APP_NAME ?></title>
  <?php include_once "temp_head.php"; ?>
</head>
<body>
  <?php include_once "temp_header.php"; ?>
  <?php include_once "temp_sidebar.php"; ?>

  <main id="main" class="main">
    <div class="pagetitle">
      <h1>課程設定</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.php">Home</a></li>
          <li class="breadcrumb-item active">課程設定</li>
        </ol>
      </nav>
    </div>

    <div class="container-fluid">
      <?php show_flash(); ?>
      
      <div class="card mb-4">
        <div class="card-body mt-3">
          <form method="GET" id="searchForm" class="d-flex align-items-center gap-2">
            <div class="input-group" style="max-width: 400px;">
              <input type="text" name="mkey" class="form-control" placeholder="課程代碼或名稱..." value="<?= e($msearchKey) ?>">
              <button type="submit" class="btn btn-primary"><i class="bi bi-search"></i></button>
            </div>
            <button type="button" class="btn btn-outline-secondary" onclick="location.href='courses_list.php'">重設</button>
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#courseModal" onclick="editCourse(0)">
              <i class="bi bi-plus-circle me-1"></i>新增
            </button>
          </form>
        </div>
      </div>

      <div class="card">
        <div class="card-body mt-4">
          <div class="table-responsive">
            <table class="table table-hover table-bordered">
              <thead>
                <tr class="table-primary">
                  <th style="width:60px;"></th>
                  <th>課程代碼</th>
                  <th>課程名稱</th>
                  <th>英文名稱</th>
                  <th>程度</th>
                  <th>教材</th>
                </tr>
              </thead>
              <tbody>
                <?php if (empty($courses)): ?>
                <tr><td colspan="6" class="text-center text-muted py-4">目前沒有資料</td></tr>
                <?php else: ?>
                <?php foreach ($courses as $c): ?>
                <tr>
                  <td>
                    <button class="btn btn-sm btn-outline-primary" onclick="editCourse(<?= $c['course_id'] ?>)" title="編輯">
                      <i class="bi bi-pencil"></i>
                    </button>
                  </td>
                  <td><?= e($c['course_code']) ?></td>
                  <td><?= e($c['course_name']) ?></td>
                  <td><small class="text-muted"><?= e($c['course_name_en']) ?></small></td>
                  <td><span class="badge bg-info"><?= e($c['level_code'] ?: '-') ?></span></td>
                  <td><small><?= e($c['textbook'] ?: '-') ?></small></td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </main>

  <!-- 課程編輯 Modal -->
  <div class="modal fade" id="courseModal" tabindex="-1">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="courseModalTitle">新增課程</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <form id="courseForm">
          <input type="hidden" name="course_id" id="course_id">
          <div class="modal-body">
            <div class="row">
              <div class="col-md-6 mb-3">
                <label class="form-label">課程代碼 <span class="text-danger">*</span></label>
                <input type="text" name="course_code" id="course_code" class="form-control" required>
              </div>
              <div class="col-md-6 mb-3">
                <label class="form-label">程度</label>
                <select name="level_code" id="level_code" class="form-select">
                  <option value="">請選擇</option>
                  <?php foreach ($levels as $l): ?>
                  <option value="<?= e($l['level_code']) ?>"><?= e($l['level_code']) ?> - <?= e($l['level_name']) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
            <div class="mb-3">
              <label class="form-label">課程名稱 <span class="text-danger">*</span></label>
              <input type="text" name="course_name" id="course_name" class="form-control" required>
            </div>
            <div class="mb-3">
              <label class="form-label">英文名稱</label>
              <input type="text" name="course_name_en" id="course_name_en" class="form-control">
            </div>
            <div class="mb-3">
              <label class="form-label">教材</label>
              <input type="text" name="textbook" id="textbook" class="form-control">
            </div>
            <div class="mb-3">
              <label class="form-label">說明</label>
              <textarea name="description" id="description" class="form-control" rows="2"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
            <button type="submit" class="btn btn-primary">儲存</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <?php include_once "temp_footer.php"; ?>

  <script>
    showSidebar("system", "courses_list");
    
    const courses = <?= json_encode($courses) ?>;

    function editCourse(id) {
      if (id === 0) {
        document.getElementById('courseModalTitle').textContent = '新增課程';
        document.getElementById('courseForm').reset();
        document.getElementById('course_id').value = '';
      } else {
        document.getElementById('courseModalTitle').textContent = '編輯課程';
        const c = courses.find(x => x.course_id == id);
        if (c) {
          document.getElementById('course_id').value = c.course_id;
          document.getElementById('course_code').value = c.course_code;
          document.getElementById('course_name').value = c.course_name;
          document.getElementById('course_name_en').value = c.course_name_en || '';
          document.getElementById('level_code').value = c.level_code || '';
          document.getElementById('textbook').value = c.textbook || '';
          document.getElementById('description').value = c.description || '';
        }
        new bootstrap.Modal(document.getElementById('courseModal')).show();
      }
    }

    document.getElementById('courseForm').addEventListener('submit', function(e) {
      e.preventDefault();
      const formData = new FormData(this);
      formData.append('action', formData.get('course_id') ? 'update' : 'create');
      formData.append('csrfToken', csrfToken);
      
      fetch('api/courses_api.php', { method: 'POST', body: formData })
        .then(r => r.json())
        .then(res => {
          if (res.success) location.reload();
          else alert(res.message);
        });
    });
  </script>
</body>
</html>
