/**
 * ISLMS - 主要 JavaScript
 */
(function() {
  "use strict";

  /**
   * 切換側邊欄
   */
  const toggleSidebar = () => {
    document.querySelector('body').classList.toggle('toggle-sidebar');
  };

  const toggleBtn = document.querySelector('.toggle-sidebar-btn');
  if (toggleBtn) {
    toggleBtn.addEventListener('click', toggleSidebar);
  }

  /**
   * 搜尋列表切換 (手機版)
   */
  const searchBarToggle = document.querySelector('.search-bar-toggle');
  if (searchBarToggle) {
    searchBarToggle.addEventListener('click', function(e) {
      e.preventDefault();
      document.querySelector('.search-bar').classList.toggle('search-bar-show');
    });
  }

  /**
   * 側邊欄下拉選單
   */
  const sidebarNavLinks = document.querySelectorAll('.sidebar-nav .nav-link');
  sidebarNavLinks.forEach(navLink => {
    navLink.addEventListener('click', function(e) {
      if (this.dataset.bsToggle === 'collapse') {
        const collapseEl = document.querySelector(this.dataset.bsTarget);
        if (collapseEl) {
          const bsCollapse = new bootstrap.Collapse(collapseEl, { toggle: true });
        }
      }
    });
  });

  /**
   * 返回頂部按鈕
   */
  const backToTop = document.querySelector('.back-to-top');
  if (backToTop) {
    const toggleBackToTop = () => {
      if (window.scrollY > 100) {
        backToTop.classList.add('active');
      } else {
        backToTop.classList.remove('active');
      }
    };
    window.addEventListener('load', toggleBackToTop);
    document.addEventListener('scroll', toggleBackToTop);
  }

  /**
   * 初始化 DataTables
   */
  const initDataTables = () => {
    const datatables = document.querySelectorAll('.datatable');
    datatables.forEach(dt => {
      if (typeof simpleDatatables !== 'undefined') {
        new simpleDatatables.DataTable(dt, {
          perPageSelect: [10, 25, 50, 100],
          columns: [{ select: 0, sortable: false }],
          labels: {
            placeholder: "搜尋...",
            perPage: "每頁 {select} 筆",
            noRows: "無資料",
            info: "顯示 {start} 至 {end} 筆，共 {rows} 筆",
          }
        });
      }
    });
  };

  /**
   * 初始化 ApexCharts
   */
  const initCharts = () => {
    // 由各頁面自行初始化
  };

  /**
   * DOM Ready
   */
  document.addEventListener('DOMContentLoaded', function() {
    initDataTables();
    initCharts();
  });

})();

/**
 * 顯示 Toast 訊息
 */
function showToast(message, type = 'success') {
  const bgClass = type === 'success' ? 'bg-success' : (type === 'error' ? 'bg-danger' : 'bg-info');
  
  const toastContainer = document.createElement('div');
  toastContainer.className = 'toast-container position-fixed top-0 end-0 p-3';
  toastContainer.innerHTML = `
    <div class="toast show ${bgClass} text-white" role="alert">
      <div class="toast-body d-flex justify-content-between align-items-center">
        ${message}
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
      </div>
    </div>
  `;
  
  document.body.appendChild(toastContainer);
  
  setTimeout(() => {
    toastContainer.remove();
  }, 3000);
}

/**
 * 確認刪除
 */
function confirmDelete(url, message = '確定要刪除嗎？') {
  if (confirm(message)) {
    window.location.href = url;
  }
}

/**
 * AJAX POST
 */
function ajaxPost(url, data, callback) {
  if (typeof csrfToken !== 'undefined') {
    data.csrfToken = csrfToken;
  }
  
  fetch(url, {
    method: 'POST',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    body: new URLSearchParams(data)
  })
  .then(response => response.json())
  .then(callback)
  .catch(error => {
    console.error('Error:', error);
    alert('操作失敗');
  });
}

/**
 * 顯示側邊欄選單
 */
function showSidebar(parentId, menuId) {
  // 展開父選單
  const parentNav = document.getElementById(parentId + '-nav');
  if (parentNav) {
    parentNav.classList.add('show');
    const parentLink = parentNav.previousElementSibling;
    if (parentLink) {
      parentLink.classList.remove('collapsed');
    }
  }
  
  // 標記當前選單
  const menuItem = document.getElementById(menuId);
  if (menuItem) {
    menuItem.classList.add('active');
  }
}

/**
 * 格式化日期
 */
function formatDate(dateStr) {
  if (!dateStr) return '';
  const date = new Date(dateStr);
  return date.toLocaleDateString('zh-TW');
}

/**
 * 格式化數字
 */
function formatNumber(num, decimals = 0) {
  return Number(num).toLocaleString('zh-TW', {
    minimumFractionDigits: decimals,
    maximumFractionDigits: decimals
  });
}
