<?php
/**
 * ISLMS - 帳號 API
 */
include_once '../src/function.php';
check_admin();

header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? '';

switch ($action) {
    case 'reset_password':
        $userId = intval($_POST['user_id'] ?? 0);
        if (!$userId) json_error('參數錯誤');
        
        // 不能重設自己的密碼
        if ($userId == $_SESSION['user_id']) json_error('不能在此處重設自己的密碼');
        
        $newPassword = generate_password(8);
        $stmt = $conn->prepare("UPDATE users SET password_hash = ? WHERE user_id = ?");
        $stmt->execute([hash_password($newPassword), $userId]);
        
        write_log('reset_password', 'users', $userId, '重設密碼');
        json_success('密碼已重設', ['password' => $newPassword]);
        break;
        
    case 'toggle_status':
        $userId = intval($_POST['user_id'] ?? 0);
        if (!$userId) json_error('參數錯誤');
        if ($userId == $_SESSION['user_id']) json_error('不能停用自己的帳號');
        
        $stmt = $conn->prepare("UPDATE users SET status = NOT status WHERE user_id = ?");
        $stmt->execute([$userId]);
        
        write_log('toggle_status', 'users', $userId, '切換帳號狀態');
        json_success('已更新');
        break;
        
    default:
        json_error('未知操作');
}
