<?php
/**
 * ISLMS - 學生 API
 */
include_once '../src/function.php';
check_login();

header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? '';

switch ($action) {
    case 'search':
        $keyword = '%' . trim($_POST['keyword'] ?? '') . '%';
        $levelCode = $_POST['level_code'] ?? '';
        $excludeSection = intval($_POST['exclude_section'] ?? 0);
        
        $sql = "SELECT student_id, student_no, name, chinese_name, level_code FROM students WHERE status = 1 AND (student_no LIKE ? OR name LIKE ? OR chinese_name LIKE ?)";
        $params = [$keyword, $keyword, $keyword];
        
        if ($levelCode) {
            $sql .= " AND level_code = ?";
            $params[] = $levelCode;
        }
        
        if ($excludeSection) {
            $sql .= " AND student_id NOT IN (SELECT student_id FROM enrollments WHERE section_id IN (SELECT section_id FROM sections WHERE offering_id = (SELECT offering_id FROM sections WHERE section_id = ?)) AND enrollment_status = 'active')";
            $params[] = $excludeSection;
        }
        
        $sql .= " ORDER BY student_no LIMIT 20";
        
        $stmt = $conn->prepare($sql);
        $stmt->execute($params);
        $data = $stmt->fetchAll();
        
        json_success('ok', $data);
        break;
        
    case 'delete':
        if (!has_role(['admin', 'staff'])) json_error('權限不足');
        
        $studentId = intval($_POST['student_id'] ?? 0);
        if (!$studentId) json_error('參數錯誤');
        
        // 軟刪除
        $stmt = $conn->prepare("UPDATE students SET status = 0 WHERE student_id = ?");
        $stmt->execute([$studentId]);
        
        write_log('delete', 'students', $studentId, '刪除學生');
        writeSystemLog('DELETE', '刪除學生 ID: ' . $studentId);
        json_success('已刪除');
        break;
        
    default:
        json_error('未知操作');
}
