<?php
/**
 * ISLMS - 成績 API
 */
include_once '../src/function.php';
check_login();

header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? '';

switch ($action) {
    case 'save':
        $sectionId = intval($_POST['section_id'] ?? 0);
        $grades = $_POST['grades'] ?? [];
        
        if (!$sectionId || empty($grades)) json_error('參數錯誤');
        
        // 權限檢查
        if ($_SESSION['user_role'] === 'teacher') {
            $stmt = $conn->prepare("SELECT 1 FROM sections s JOIN offerings o ON s.offering_id = o.offering_id WHERE s.section_id = ? AND (s.teacher_id = ? OR o.teacher_id = ?)");
            $stmt->execute([$sectionId, $_SESSION['user_id'], $_SESSION['user_id']]);
            if (!$stmt->fetch()) json_error('權限不足');
        }
        
        try {
            $conn->beginTransaction();
            
            foreach ($grades as $enrollmentId => $items) {
                $totalScore = 0;
                $hasScore = false;
                
                foreach ($items as $itemId => $score) {
                    if ($score === '' || $score === null) continue;
                    
                    $score = floatval($score);
                    
                    // 取得權重
                    $stmt = $conn->prepare("SELECT weight FROM grade_items WHERE item_id = ?");
                    $stmt->execute([$itemId]);
                    $item = $stmt->fetch();
                    $weight = $item['weight'] ?? 0;
                    $weighted = $score * $weight / 100;
                    
                    // Upsert 成績
                    $sql = "INSERT INTO grades (enrollment_id, item_id, score, weighted_score, graded_by, graded_at) 
                            VALUES (?, ?, ?, ?, ?, NOW())
                            ON DUPLICATE KEY UPDATE score = VALUES(score), weighted_score = VALUES(weighted_score), graded_by = VALUES(graded_by), graded_at = NOW()";
                    $stmt = $conn->prepare($sql);
                    $stmt->execute([$enrollmentId, $itemId, $score, $weighted, $_SESSION['user_id']]);
                    
                    $totalScore += $weighted;
                    $hasScore = true;
                }
                
                // 更新總分
                if ($hasScore) {
                    $grade = $totalScore >= 80 ? 'A' : ($totalScore >= 70 ? 'B' : ($totalScore >= 60 ? 'C' : 'D'));
                    $stmt = $conn->prepare("UPDATE enrollments SET final_score = ?, final_grade = ? WHERE enrollment_id = ?");
                    $stmt->execute([$totalScore, $grade, $enrollmentId]);
                }
            }
            
            $conn->commit();
            write_log('save_grades', 'grades', $sectionId, '儲存成績');
            json_success('成績已儲存');
        } catch (Exception $e) {
            $conn->rollBack();
            json_error('儲存失敗：' . $e->getMessage());
        }
        break;
        
    case 'calculate_all':
        $sectionId = intval($_POST['section_id'] ?? 0);
        if (!$sectionId) json_error('參數錯誤');
        
        // 權限檢查
        if ($_SESSION['user_role'] === 'teacher') {
            $stmt = $conn->prepare("SELECT 1 FROM sections s JOIN offerings o ON s.offering_id = o.offering_id WHERE s.section_id = ? AND (s.teacher_id = ? OR o.teacher_id = ?)");
            $stmt->execute([$sectionId, $_SESSION['user_id'], $_SESSION['user_id']]);
            if (!$stmt->fetch()) json_error('權限不足');
        }
        
        try {
            $conn->beginTransaction();
            
            // 取得所有選課記錄
            $stmt = $conn->prepare("SELECT enrollment_id, student_id FROM enrollments WHERE section_id = ? AND enrollment_status = 'active'");
            $stmt->execute([$sectionId]);
            $enrollments = $stmt->fetchAll();
            
            foreach ($enrollments as $e) {
                // 計算成績總分
                $stmt = $conn->prepare("SELECT SUM(weighted_score) as total FROM grades WHERE enrollment_id = ?");
                $stmt->execute([$e['enrollment_id']]);
                $total = $stmt->fetchColumn() ?: 0;
                
                $grade = $total >= 80 ? 'A' : ($total >= 70 ? 'B' : ($total >= 60 ? 'C' : 'D'));
                
                // 計算出席率
                $stmt = $conn->prepare("SELECT attendance_status, COUNT(*) as cnt FROM attendance WHERE section_id = ? AND student_id = ? GROUP BY attendance_status");
                $stmt->execute([$sectionId, $e['student_id']]);
                $stats = [];
                $totalClasses = 0;
                foreach ($stmt->fetchAll() as $st) {
                    $stats[$st['attendance_status']] = $st['cnt'];
                    $totalClasses += $st['cnt'];
                }
                $present = ($stats['P'] ?? 0) + ($stats['L'] ?? 0) * 0.5;
                $attendanceRate = $totalClasses > 0 ? round($present / $totalClasses * 100, 1) : null;
                
                // 更新
                $stmt = $conn->prepare("UPDATE enrollments SET final_score = ?, final_grade = ?, attendance_rate = ? WHERE enrollment_id = ?");
                $stmt->execute([$total ?: null, $total > 0 ? $grade : null, $attendanceRate, $e['enrollment_id']]);
            }
            
            $conn->commit();
            json_success('已重新計算');
        } catch (Exception $e) {
            $conn->rollBack();
            json_error('計算失敗');
        }
        break;
        
    default:
        json_error('未知操作');
}
