<?php
/**
 * ISLMS - 課程 API
 */
include_once '../src/function.php';
check_admin();

header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? '';

switch ($action) {
    case 'create':
    case 'update':
        $courseId = intval($_POST['course_id'] ?? 0);
        $data = [
            'course_code' => trim($_POST['course_code'] ?? ''),
            'course_name' => trim($_POST['course_name'] ?? ''),
            'course_name_en' => trim($_POST['course_name_en'] ?? '') ?: null,
            'level_code' => $_POST['level_code'] ?? null,
            'textbook' => trim($_POST['textbook'] ?? '') ?: null,
            'description' => trim($_POST['description'] ?? '') ?: null
        ];
        
        if (empty($data['course_code']) || empty($data['course_name'])) {
            json_error('課程代碼和名稱為必填');
        }
        
        if ($courseId) {
            // 更新
            $sql = "UPDATE courses SET course_code=?, course_name=?, course_name_en=?, level_code=?, textbook=?, description=?, updated_by=? WHERE course_id=?";
            $stmt = $conn->prepare($sql);
            $stmt->execute([$data['course_code'], $data['course_name'], $data['course_name_en'], $data['level_code'], $data['textbook'], $data['description'], $_SESSION['user_account'], $courseId]);
            write_log('update', 'courses', $courseId, '更新課程');
            json_success('課程已更新');
        } else {
            // 新增
            $sql = "INSERT INTO courses (course_code, course_name, course_name_en, level_code, textbook, description, status, created_by) VALUES (?,?,?,?,?,?,1,?)";
            $stmt = $conn->prepare($sql);
            $stmt->execute([$data['course_code'], $data['course_name'], $data['course_name_en'], $data['level_code'], $data['textbook'], $data['description'], $_SESSION['user_account']]);
            write_log('create', 'courses', $conn->lastInsertId(), '新增課程');
            json_success('課程已新增');
        }
        break;
        
    case 'delete':
        $courseId = intval($_POST['course_id'] ?? 0);
        if (!$courseId) json_error('參數錯誤');
        
        $stmt = $conn->prepare("UPDATE courses SET status = 0 WHERE course_id = ?");
        $stmt->execute([$courseId]);
        write_log('delete', 'courses', $courseId, '刪除課程');
        json_success('已刪除');
        break;
        
    default:
        json_error('未知操作');
}
