<?php
/**
 * ISLMS - 點名 API
 */
include_once '../src/function.php';
check_login();

header('Content-Type: application/json; charset=utf-8');

$action = $_POST['action'] ?? '';

switch ($action) {
    case 'save':
        $sectionId = intval($_POST['section_id'] ?? 0);
        $classDate = $_POST['class_date'] ?? '';
        $attendance = $_POST['attendance'] ?? [];
        
        if (!$sectionId || !$classDate || empty($attendance)) {
            json_error('參數錯誤');
        }
        
        // 權限檢查
        if ($_SESSION['user_role'] === 'teacher') {
            $stmt = $conn->prepare("SELECT 1 FROM sections s JOIN offerings o ON s.offering_id = o.offering_id WHERE s.section_id = ? AND (s.teacher_id = ? OR o.teacher_id = ?)");
            $stmt->execute([$sectionId, $_SESSION['user_id'], $_SESSION['user_id']]);
            if (!$stmt->fetch()) json_error('權限不足');
        }
        
        // 檢查是否鎖定
        $stmt = $conn->prepare("SELECT is_locked FROM attendance WHERE section_id = ? AND class_date = ? AND is_locked = 1 LIMIT 1");
        $stmt->execute([$sectionId, $classDate]);
        if ($stmt->fetch()) json_error('點名記錄已鎖定');
        
        try {
            $conn->beginTransaction();
            
            foreach ($attendance as $studentId => $data) {
                $status = $data['status'] ?? 'P';
                $note = trim($data['note'] ?? '');
                
                // Upsert
                $sql = "INSERT INTO attendance (section_id, student_id, class_date, attendance_status, note, recorded_by, created_at) 
                        VALUES (?, ?, ?, ?, ?, ?, NOW())
                        ON DUPLICATE KEY UPDATE attendance_status = VALUES(attendance_status), note = VALUES(note), recorded_by = VALUES(recorded_by)";
                $stmt = $conn->prepare($sql);
                $stmt->execute([$sectionId, $studentId, $classDate, $status, $note, $_SESSION['user_id']]);
            }
            
            $conn->commit();
            write_log('save_attendance', 'attendance', $sectionId, "點名日期: $classDate");
            json_success('點名已儲存');
        } catch (Exception $e) {
            $conn->rollBack();
            json_error('儲存失敗：' . $e->getMessage());
        }
        break;
        
    case 'lock':
        if (!has_role(['admin', 'staff'])) json_error('權限不足');
        
        $sectionId = intval($_POST['section_id'] ?? 0);
        $classDate = $_POST['class_date'] ?? '';
        
        $stmt = $conn->prepare("UPDATE attendance SET is_locked = 1, locked_at = NOW(), locked_by = ? WHERE section_id = ? AND class_date = ?");
        $stmt->execute([$_SESSION['user_id'], $sectionId, $classDate]);
        
        json_success('已鎖定');
        break;
        
    case 'unlock':
        if (!has_role(['admin', 'staff'])) json_error('權限不足');
        
        $sectionId = intval($_POST['section_id'] ?? 0);
        $classDate = $_POST['class_date'] ?? '';
        
        $stmt = $conn->prepare("UPDATE attendance SET is_locked = 0, locked_at = NULL, locked_by = NULL WHERE section_id = ? AND class_date = ?");
        $stmt->execute([$sectionId, $classDate]);
        
        json_success('已解鎖');
        break;
        
    default:
        json_error('未知操作');
}
