# 國際生學習管理系統 (ISLMS) v2
## International Student Learning Management System

### 系統簡介

本系統為華語教學中心設計的國際生學習管理系統，支援學位生與交換生的華語課程管理，包含開班、選課、點名、成績等完整功能。

### 技術架構

- **後端**: PHP 8.1+
- **資料庫**: MySQL 8.0+ (utf8mb4)
- **前端**: Bootstrap 5.3 + jQuery 3.7
- **圖表**: ApexCharts
- **模板**: NiceAdmin 風格

### 目錄結構

```
islms_v2/
├── api/                    # AJAX API 端點
│   ├── attendance_api.php
│   ├── grades_api.php
│   ├── sections_api.php
│   └── ...
├── assets/                 # 靜態資源
│   ├── css/style.css
│   ├── js/main.js
│   ├── img/
│   └── vendor/             # 第三方套件
├── src/                    # 核心程式
│   ├── config.php          # 系統設定
│   ├── db.php              # 資料庫連線
│   ├── globarvar.php       # 全域變數
│   └── function.php        # 共用函數
├── uploads/                # 上傳檔案
├── index.php               # 儀表板首頁
├── login.php               # 登入頁面
├── students_*.php          # 學生管理
├── offerings_*.php         # 開班管理
├── sections_*.php          # 班級管理
├── attendance_*.php        # 點名管理
├── grades_*.php            # 成績管理
├── transcripts_list.php    # 成績單
├── report_*.php            # 統計報表
├── users_*.php             # 帳號管理
├── settings_list.php       # 系統設定
├── temp_*.php              # 模板檔案
└── .htaccess               # Apache 設定
```

### 功能模組

| 模組 | 功能說明 |
|------|----------|
| **儀表板** | 統計總覽、快捷操作、程度分布圖 |
| **學生管理** | 學生資料維護、Excel 批次匯入 |
| **開班管理** | 建立開班、自動編班、班級管理 |
| **班級管理** | 名單查看、調班、退選、加選 |
| **點名管理** | 線上點名、6種狀態、鎖定功能 |
| **成績管理** | 自訂評分項目、即時計算總分 |
| **成績單** | 線上產生、列印成績單 |
| **統計報表** | 出席/成績統計、CSV 匯出 |
| **帳號管理** | 使用者管理、重設密碼 |
| **系統設定** | 基本設定、SMTP 郵件設定 |

### 安裝步驟

#### 1. 環境需求
- Apache/Nginx 網頁伺服器
- PHP 8.1 或以上版本
- MySQL 8.0 或以上版本
- PHP 擴充套件: pdo_mysql, mbstring, json

#### 2. 資料庫設定
```sql
-- 建立資料庫
CREATE DATABASE islms CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- 匯入資料表
mysql -u root -p islms < islms_schema.sql
```

#### 3. 系統設定
編輯 `src/config.php`:
```php
$dbhost = 'localhost';
$dbname = 'islms';
$dbusername = 'your_username';
$dbpassword = 'your_password';
```

#### 4. 第三方套件
將以下套件放入 `assets/vendor/` 目錄：
- Bootstrap 5.3
- Bootstrap Icons
- jQuery 3.7
- ApexCharts
- Simple-DataTables

或使用 CDN (修改 `temp_head.php` 和 `temp_footer.php`)

#### 5. 預設帳號
- **帳號**: `admin`
- **密碼**: `admin123`
- ⚠️ 請登入後立即修改密碼！

### 使用者角色

| 角色 | 說明 | 權限範圍 |
|------|------|----------|
| `admin` | 系統管理員 | 所有功能 + 系統設定 |
| `staff` | 教務承辦 | 開班、選課、點名、成績管理 |
| `teacher` | 授課教師 | 自己班級的點名、成績輸入 |

### 出席狀態代碼

| 代碼 | 說明 | 顏色 |
|------|------|------|
| P | 出席 Present | 綠色 |
| L | 遲到 Late | 黃色 |
| A | 缺席 Absent | 紅色 |
| E | 請假 Excused | 藍色 |
| O | 公假 Official | 靛色 |
| S | 病假 Sick | 灰色 |

### 成績等第標準

| 等第 | 分數範圍 |
|------|----------|
| A | 80 - 100 |
| B | 70 - 79 |
| C | 60 - 69 |
| D | 0 - 59 |

### API 說明

所有 API 端點位於 `/api/` 目錄，使用 POST 方法，回傳 JSON 格式：

```json
{
  "success": true,
  "message": "操作成功",
  "data": {...}
}
```

### 安全機制

- CSRF Token 保護
- SQL Injection 防護 (PDO Prepared Statements)
- XSS 防護 (htmlspecialchars 輸出跳脫)
- 密碼雜湊 (password_hash)
- Session 逾時控制

### 版本歷程

- **v2.0.0** (2024-12)
  - 重構程式架構
  - 採用 NiceAdmin 風格
  - 改善使用者介面
  - 新增統計報表功能

### 授權

本系統僅供教學與學術使用。

---

© 2024 國際生學習管理系統 ISLMS
