<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">新增班級</h1>
</div>

<div class="card">
    <div class="card-body">
        <form method="post">
            <?= csrfField() ?>
            
            <div class="mb-3">
                <label class="form-label">所屬開班</label>
                <input type="text" class="form-control" readonly value="<?= e($offering['course_name']) ?> (<?= e($offering['semester']) ?>)">
            </div>
            
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">班級名稱 <span class="text-danger">*</span></label>
                    <input type="text" name="section_name" class="form-control" required placeholder="例：A班"
                           value="<?= e($_POST['section_name'] ?? '') ?>">
                </div>
                
                <div class="col-md-4 mb-3">
                    <label class="form-label">授課教師</label>
                    <select name="teacher_id" class="form-select">
                        <option value="">同開班設定 (<?= e($offering['teacher_name'] ?? '未指定') ?>)</option>
                        <?php foreach ($teachers as $t): ?>
                        <option value="<?= $t['user_id'] ?>" <?= ($_POST['teacher_id'] ?? '') == $t['user_id'] ? 'selected' : '' ?>>
                            <?= e($t['name']) ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-4 mb-3">
                    <label class="form-label">人數上限</label>
                    <input type="number" name="max_students" class="form-control" min="1" max="50"
                           value="<?= e($_POST['max_students'] ?? $offering['max_students_per_section'] ?? 12) ?>">
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">教室</label>
                <input type="text" name="classroom" class="form-control" placeholder="留空則同開班設定"
                       value="<?= e($_POST['classroom'] ?? '') ?>">
            </div>
            
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>儲存</button>
                <a href="<?= url('offerings.php?action=view&id=' . $offering['offering_id']) ?>" class="btn btn-secondary">取消</a>
            </div>
        </form>
    </div>
</div>
