<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0"><?= e($offering['course_name']) ?></h1>
    <div>
        <?php if ($auth->hasRole(['admin', 'staff'])): ?>
        <button type="button" class="btn btn-success" onclick="autoAssign(<?= $offering['offering_id'] ?>)">
            <i class="bi bi-magic me-1"></i>自動編班
        </button>
        <a href="<?= url('offerings.php?action=edit&id=' . $offering['offering_id']) ?>" class="btn btn-primary">
            <i class="bi bi-pencil me-1"></i>編輯
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- 開班資訊 -->
<div class="card mb-4">
    <div class="card-header"><i class="bi bi-info-circle me-2"></i>開班資訊</div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="text-muted small">學期</label>
                <div class="fw-bold"><?= e($offering['semester']) ?></div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-muted small">程度</label>
                <div><span class="badge bg-info fs-6"><?= getLevelName($offering['level_code']) ?></span></div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-muted small">授課教師</label>
                <div class="fw-bold"><?= e($offering['teacher_name'] ?? '-') ?></div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-muted small">狀態</label>
                <?php $status = getOfferingStatus($offering['offering_status']); ?>
                <div><span class="badge bg-<?= $status['class'] ?> fs-6"><?= $status['name'] ?></span></div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3 mb-3">
                <label class="text-muted small">課程期間</label>
                <div><?= formatDate($offering['start_date']) ?> ~ <?= formatDate($offering['end_date']) ?></div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-muted small">上課時間</label>
                <div><?= e($offering['schedule']) ?> <?= e($offering['class_time']) ?></div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-muted small">教室</label>
                <div><?= e($offering['classroom'] ?: '-') ?></div>
            </div>
            <div class="col-md-3 mb-3">
                <label class="text-muted small">每班上限</label>
                <div><?= $offering['max_students_per_section'] ?> 人</div>
            </div>
        </div>
    </div>
</div>

<!-- 班級列表 -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-collection me-2"></i>班級列表</span>
        <?php if ($auth->hasRole(['admin', 'staff'])): ?>
        <a href="<?= url('sections.php?action=create&offering_id=' . $offering['offering_id']) ?>" class="btn btn-sm btn-primary">
            <i class="bi bi-plus-lg me-1"></i>新增班級
        </a>
        <?php endif; ?>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th>班級名稱</th>
                        <th>授課教師</th>
                        <th>教室</th>
                        <th>人數</th>
                        <th>狀態</th>
                        <th width="150">操作</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($sections)): ?>
                    <tr><td colspan="6" class="text-center text-muted py-4">尚未建立班級，請點擊「自動編班」或「新增班級」</td></tr>
                    <?php else: ?>
                    <?php foreach ($sections as $sec): ?>
                    <tr>
                        <td><strong><?= e($sec['section_name']) ?></strong></td>
                        <td><?= e($sec['teacher_name'] ?? $offering['teacher_name'] ?? '-') ?></td>
                        <td><?= e($sec['classroom'] ?? $offering['classroom'] ?? '-') ?></td>
                        <td>
                            <span class="badge bg-<?= $sec['current_count'] >= $sec['max_students'] ? 'danger' : 'success' ?>">
                                <?= $sec['current_count'] ?> / <?= $sec['max_students'] ?>
                            </span>
                        </td>
                        <td>
                            <?php if ($sec['section_status'] === 'active'): ?>
                            <span class="badge bg-success">進行中</span>
                            <?php else: ?>
                            <span class="badge bg-secondary">已結束</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="<?= url('sections.php?action=view&id=' . $sec['section_id']) ?>" class="btn btn-sm btn-outline-info" title="查看"><i class="bi bi-eye"></i></a>
                            <a href="<?= url('attendance.php?section_id=' . $sec['section_id']) ?>" class="btn btn-sm btn-outline-primary" title="點名"><i class="bi bi-clipboard-check"></i></a>
                            <a href="<?= url('grades.php?section_id=' . $sec['section_id']) ?>" class="btn btn-sm btn-outline-warning" title="成績"><i class="bi bi-journal-text"></i></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function autoAssign(offeringId) {
    const maxPerSection = prompt('請輸入每班人數上限：', '12');
    if (!maxPerSection) return;
    
    if (!confirm('確定要執行自動編班嗎？系統將依程度自動分配學生到各班級。')) return;
    
    $.post('<?= url('offerings.php') ?>', {
        action: 'auto_assign',
        id: offeringId,
        max_per_section: maxPerSection,
        <?= CSRF_TOKEN_NAME ?>: csrfToken
    }, function(res) {
        alert(res.message);
        if (res.success) location.reload();
    });
}
</script>
