<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0"><?= $action === 'edit' ? '編輯開班' : '新增開班' ?></h1>
</div>

<?php if (!empty($errors)): ?>
<div class="alert alert-danger">
    <ul class="mb-0">
        <?php foreach ($errors as $err): ?>
        <li><?= e($err) ?></li>
        <?php endforeach; ?>
    </ul>
</div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <form method="post">
            <?= csrfField() ?>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">課程 <span class="text-danger">*</span></label>
                    <select name="course_id" class="form-select" required>
                        <option value="">請選擇課程</option>
                        <?php foreach ($courses as $c): ?>
                        <option value="<?= $c['course_id'] ?>" <?= ($offering['course_id'] ?? $_POST['course_id'] ?? '') == $c['course_id'] ? 'selected' : '' ?>>
                            <?= e($c['course_name']) ?> (<?= e($c['level_code']) ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-3 mb-3">
                    <label class="form-label">學期 <span class="text-danger">*</span></label>
                    <input type="text" name="semester" class="form-control" required placeholder="例：114-1"
                           value="<?= e($offering['semester'] ?? $_POST['semester'] ?? '') ?>">
                </div>
                
                <div class="col-md-3 mb-3">
                    <label class="form-label">狀態</label>
                    <select name="offering_status" class="form-select">
                        <option value="draft" <?= ($offering['offering_status'] ?? '') === 'draft' ? 'selected' : '' ?>>草稿</option>
                        <option value="active" <?= ($offering['offering_status'] ?? '') === 'active' ? 'selected' : '' ?>>進行中</option>
                        <option value="closed" <?= ($offering['offering_status'] ?? '') === 'closed' ? 'selected' : '' ?>>已結束</option>
                    </select>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">授課教師</label>
                    <select name="teacher_id" class="form-select">
                        <option value="">請選擇</option>
                        <?php foreach ($teachers as $t): ?>
                        <option value="<?= $t['user_id'] ?>" <?= ($offering['teacher_id'] ?? $_POST['teacher_id'] ?? '') == $t['user_id'] ? 'selected' : '' ?>>
                            <?= e($t['name']) ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-4 mb-3">
                    <label class="form-label">教室</label>
                    <input type="text" name="classroom" class="form-control"
                           value="<?= e($offering['classroom'] ?? $_POST['classroom'] ?? '') ?>">
                </div>
                
                <div class="col-md-4 mb-3">
                    <label class="form-label">每班人數上限</label>
                    <input type="number" name="max_students_per_section" class="form-control" min="1" max="50"
                           value="<?= e($offering['max_students_per_section'] ?? $_POST['max_students_per_section'] ?? 12) ?>">
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="form-label">開課日期 <span class="text-danger">*</span></label>
                    <input type="date" name="start_date" class="form-control" required
                           value="<?= e($offering['start_date'] ?? $_POST['start_date'] ?? '') ?>">
                </div>
                
                <div class="col-md-3 mb-3">
                    <label class="form-label">結課日期 <span class="text-danger">*</span></label>
                    <input type="date" name="end_date" class="form-control" required
                           value="<?= e($offering['end_date'] ?? $_POST['end_date'] ?? '') ?>">
                </div>
                
                <div class="col-md-3 mb-3">
                    <label class="form-label">上課時間</label>
                    <input type="text" name="class_time" class="form-control" placeholder="例：09:10-12:00"
                           value="<?= e($offering['class_time'] ?? $_POST['class_time'] ?? '') ?>">
                </div>
                
                <div class="col-md-3 mb-3">
                    <label class="form-label">上課週期</label>
                    <input type="text" name="schedule" class="form-control" placeholder="例：週二、四"
                           value="<?= e($offering['schedule'] ?? $_POST['schedule'] ?? '') ?>">
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-3 mb-3">
                    <label class="form-label">每週時數</label>
                    <input type="number" name="hours_per_week" class="form-control" step="0.5"
                           value="<?= e($offering['hours_per_week'] ?? $_POST['hours_per_week'] ?? '') ?>">
                </div>
                
                <div class="col-md-3 mb-3">
                    <label class="form-label">總時數</label>
                    <input type="number" name="total_hours" class="form-control" step="0.5"
                           value="<?= e($offering['total_hours'] ?? $_POST['total_hours'] ?? '') ?>">
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">備註</label>
                <textarea name="note" class="form-control" rows="2"><?= e($offering['note'] ?? $_POST['note'] ?? '') ?></textarea>
            </div>
            
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>儲存</button>
                <a href="<?= url('offerings.php') ?>" class="btn btn-secondary">取消</a>
            </div>
        </form>
    </div>
</div>
