<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= e($pageTitle ?? APP_NAME) ?></title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <!-- DataTables -->
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    
    <style>
        :root {
            --sidebar-width: 260px;
            --header-height: 60px;
            --primary-color: #2c5282;
            --sidebar-bg: #1a365d;
        }
        
        body {
            background-color: #f7fafc;
            font-family: "Microsoft JhengHei", "Noto Sans TC", sans-serif;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: var(--sidebar-width);
            height: 100vh;
            background: var(--sidebar-bg);
            color: #fff;
            z-index: 1000;
            overflow-y: auto;
        }
        
        .sidebar-brand {
            height: var(--header-height);
            display: flex;
            align-items: center;
            padding: 0 1.25rem;
            background: rgba(0,0,0,0.1);
            font-weight: bold;
            font-size: 1.1rem;
        }
        
        .sidebar-nav {
            padding: 1rem 0;
        }
        
        .nav-section {
            padding: 0.5rem 1.25rem;
            font-size: 0.75rem;
            text-transform: uppercase;
            color: rgba(255,255,255,0.5);
            letter-spacing: 0.05em;
        }
        
        .sidebar .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.65rem 1.25rem;
            display: flex;
            align-items: center;
            transition: all 0.2s;
        }
        
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: #fff;
            background: rgba(255,255,255,0.1);
        }
        
        .sidebar .nav-link i {
            margin-right: 0.75rem;
            width: 20px;
            text-align: center;
        }
        
        /* Main Content */
        .main-wrapper {
            margin-left: var(--sidebar-width);
            min-height: 100vh;
        }
        
        .main-header {
            height: var(--header-height);
            background: #fff;
            border-bottom: 1px solid #e2e8f0;
            padding: 0 1.5rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .main-content {
            padding: 1.5rem;
        }
        
        /* Cards */
        .card {
            border: none;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            border-radius: 0.5rem;
        }
        
        .card-header {
            background: #fff;
            border-bottom: 1px solid #e2e8f0;
            font-weight: 600;
        }
        
        /* Stats Card */
        .stat-card {
            border-left: 4px solid var(--primary-color);
        }
        
        .stat-card.success { border-left-color: #38a169; }
        .stat-card.warning { border-left-color: #d69e2e; }
        .stat-card.danger { border-left-color: #e53e3e; }
        .stat-card.info { border-left-color: #3182ce; }
        
        .stat-value {
            font-size: 1.75rem;
            font-weight: 700;
            color: #2d3748;
        }
        
        .stat-label {
            color: #718096;
            font-size: 0.875rem;
        }
        
        /* Tables */
        .table th {
            font-weight: 600;
            color: #4a5568;
            background: #f7fafc;
        }
        
        /* Buttons */
        .btn-primary {
            background: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        .btn-primary:hover {
            background: #1a365d;
            border-color: #1a365d;
        }
        
        /* Badge improvements */
        .badge {
            font-weight: 500;
            padding: 0.35em 0.65em;
        }
        
        /* Mobile responsive */
        @media (max-width: 991.98px) {
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s;
            }
            
            .sidebar.show {
                transform: translateX(0);
            }
            
            .main-wrapper {
                margin-left: 0;
            }
            
            .sidebar-toggle {
                display: block !important;
            }
        }
        
        .sidebar-toggle {
            display: none;
        }
    </style>
    
    <?php if (isset($extraCss)): ?>
    <?= $extraCss ?>
    <?php endif; ?>
</head>
<body>
    <!-- Sidebar -->
    <aside class="sidebar" id="sidebar">
        <div class="sidebar-brand">
            <i class="bi bi-mortarboard-fill me-2"></i>
            <?= APP_NAME ?>
        </div>
        
        <nav class="sidebar-nav">
            <div class="nav-section">主要功能</div>
            <a href="<?= url('dashboard.php') ?>" class="nav-link <?= isCurrentPage('dashboard.php') ? 'active' : '' ?>">
                <i class="bi bi-speedometer2"></i> 儀表板
            </a>
            
            <?php if ($auth->hasRole(['admin', 'staff'])): ?>
            <a href="<?= url('offerings.php') ?>" class="nav-link <?= isCurrentPage('offerings.php') ? 'active' : '' ?>">
                <i class="bi bi-calendar-event"></i> 開班管理
            </a>
            <a href="<?= url('students.php') ?>" class="nav-link <?= isCurrentPage('students.php') ? 'active' : '' ?>">
                <i class="bi bi-people"></i> 學生管理
            </a>
            <?php endif; ?>
            
            <a href="<?= url('sections.php') ?>" class="nav-link <?= isCurrentPage('sections.php') ? 'active' : '' ?>">
                <i class="bi bi-collection"></i> 班級管理
            </a>
            
            <div class="nav-section mt-3">教學管理</div>
            <a href="<?= url('attendance.php') ?>" class="nav-link <?= isCurrentPage('attendance.php') ? 'active' : '' ?>">
                <i class="bi bi-clipboard-check"></i> 點名管理
            </a>
            <a href="<?= url('grades.php') ?>" class="nav-link <?= isCurrentPage('grades.php') ? 'active' : '' ?>">
                <i class="bi bi-journal-text"></i> 成績管理
            </a>
            
            <?php if ($auth->hasRole(['admin', 'staff'])): ?>
            <a href="<?= url('transcripts.php') ?>" class="nav-link <?= isCurrentPage('transcripts.php') ? 'active' : '' ?>">
                <i class="bi bi-file-earmark-pdf"></i> 成績單
            </a>
            <?php endif; ?>
            
            <div class="nav-section mt-3">報表查詢</div>
            <a href="<?= url('reports.php') ?>" class="nav-link <?= isCurrentPage('reports.php') ? 'active' : '' ?>">
                <i class="bi bi-graph-up"></i> 統計報表
            </a>
            
            <?php if ($auth->isAdmin()): ?>
            <div class="nav-section mt-3">系統管理</div>
            <a href="<?= url('users.php') ?>" class="nav-link <?= isCurrentPage('users.php') ? 'active' : '' ?>">
                <i class="bi bi-person-gear"></i> 帳號管理
            </a>
            <a href="<?= url('courses.php') ?>" class="nav-link <?= isCurrentPage('courses.php') ? 'active' : '' ?>">
                <i class="bi bi-book"></i> 課程設定
            </a>
            <a href="<?= url('settings.php') ?>" class="nav-link <?= isCurrentPage('settings.php') ? 'active' : '' ?>">
                <i class="bi bi-gear"></i> 系統設定
            </a>
            <?php endif; ?>
        </nav>
    </aside>
    
    <!-- Main Content -->
    <div class="main-wrapper">
        <header class="main-header">
            <div class="d-flex align-items-center">
                <button class="btn btn-link sidebar-toggle me-2" onclick="toggleSidebar()">
                    <i class="bi bi-list fs-4"></i>
                </button>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="<?= url('dashboard.php') ?>">首頁</a></li>
                        <?php if (isset($breadcrumb)): ?>
                            <?php foreach ($breadcrumb as $item): ?>
                            <li class="breadcrumb-item <?= isset($item['active']) ? 'active' : '' ?>">
                                <?php if (isset($item['url'])): ?>
                                <a href="<?= $item['url'] ?>"><?= e($item['title']) ?></a>
                                <?php else: ?>
                                <?= e($item['title']) ?>
                                <?php endif; ?>
                            </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ol>
                </nav>
            </div>
            
            <div class="d-flex align-items-center">
                <div class="dropdown">
                    <button class="btn btn-link text-dark dropdown-toggle text-decoration-none" type="button" data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle me-1"></i>
                        <?= e($currentUser['name']) ?>
                        <span class="badge bg-secondary ms-1"><?= getRoleName($currentUser['role']) ?></span>
                    </button>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="<?= url('profile.php') ?>"><i class="bi bi-person me-2"></i>個人資料</a></li>
                        <li><a class="dropdown-item" href="<?= url('password.php') ?>"><i class="bi bi-key me-2"></i>變更密碼</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form action="<?= url('logout.php') ?>" method="post" class="d-inline">
                                <?= csrfField() ?>
                                <button type="submit" class="dropdown-item text-danger">
                                    <i class="bi bi-box-arrow-right me-2"></i>登出
                                </button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </header>
        
        <main class="main-content">
            <?php if ($successMsg = flash('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i><?= e($successMsg) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>
            
            <?php if ($errorMsg = flash('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="bi bi-exclamation-triangle me-2"></i><?= e($errorMsg) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
            <?php endif; ?>
            
            <?= $content ?>
        </main>
    </div>
    
    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    
    <script>
        // CSRF Token for AJAX
        const csrfToken = '<?= csrfToken() ?>';
        
        $.ajaxSetup({
            headers: {
                'X-Requested-With': 'XMLHttpRequest'
            },
            data: {
                '<?= CSRF_TOKEN_NAME ?>': csrfToken
            }
        });
        
        // Sidebar toggle for mobile
        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('show');
        }
        
        // DataTable 中文化
        const dataTableLang = {
            "processing": "處理中...",
            "loadingRecords": "載入中...",
            "lengthMenu": "顯示 _MENU_ 筆",
            "zeroRecords": "沒有符合的資料",
            "info": "第 _START_ 至 _END_ 筆，共 _TOTAL_ 筆",
            "infoEmpty": "第 0 至 0 筆，共 0 筆",
            "infoFiltered": "(從 _MAX_ 筆中篩選)",
            "search": "搜尋：",
            "paginate": {
                "first": "第一頁",
                "previous": "上一頁",
                "next": "下一頁",
                "last": "最後一頁"
            }
        };
        
        // 初始化所有 DataTable
        $(document).ready(function() {
            $('.data-table').DataTable({
                language: dataTableLang,
                pageLength: 20,
                order: []
            });
        });
        
        // Toast 通知
        function showToast(message, type = 'success') {
            const toast = $(`
                <div class="toast align-items-center text-white bg-${type} border-0" role="alert">
                    <div class="d-flex">
                        <div class="toast-body">${message}</div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                    </div>
                </div>
            `);
            
            let container = $('#toast-container');
            if (!container.length) {
                container = $('<div id="toast-container" class="toast-container position-fixed top-0 end-0 p-3"></div>');
                $('body').append(container);
            }
            
            container.append(toast);
            const bsToast = new bootstrap.Toast(toast[0]);
            bsToast.show();
            
            toast.on('hidden.bs.toast', function() {
                $(this).remove();
            });
        }
        
        // 確認刪除
        function confirmDelete(message = '確定要刪除嗎？此操作無法復原。') {
            return confirm(message);
        }
    </script>
    
    <?php if (isset($extraJs)): ?>
    <?= $extraJs ?>
    <?php endif; ?>
</body>
</html>
