<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">成績管理</h1>
</div>

<div class="alert alert-info">
    <i class="bi bi-info-circle me-2"></i>請選擇要輸入成績的班級
</div>

<div class="row">
    <?php if (empty($sections)): ?>
    <div class="col-12">
        <div class="card">
            <div class="card-body text-center text-muted py-5">
                <i class="bi bi-inbox fs-1 mb-3 d-block"></i>
                目前沒有可管理的班級
            </div>
        </div>
    </div>
    <?php else: ?>
    <?php foreach ($sections as $s): ?>
    <div class="col-md-6 col-lg-4 mb-4">
        <div class="card h-100">
            <div class="card-body">
                <h5 class="card-title"><?= e($s['course_name']) ?></h5>
                <h6 class="card-subtitle mb-2 text-muted"><?= e($s['section_name']) ?></h6>
                <p class="card-text">
                    <span class="badge bg-info"><?= e($s['level_code']) ?></span>
                    <span class="badge bg-secondary"><?= $s['current_count'] ?> 人</span>
                </p>
                <p class="card-text small text-muted">
                    <i class="bi bi-person me-1"></i><?= e($s['teacher_name'] ?? '-') ?>
                </p>
            </div>
            <div class="card-footer bg-transparent">
                <a href="<?= url('grades.php?section_id=' . $s['section_id']) ?>" class="btn btn-warning btn-sm w-100">
                    <i class="bi bi-journal-text me-1"></i>輸入成績
                </a>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    <?php endif; ?>
</div>
