<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">儀表板</h1>
    <div class="text-muted">
        <i class="bi bi-calendar3 me-1"></i>
        <?= date('Y年m月d日 l') ?>
    </div>
</div>

<!-- 統計卡片 -->
<div class="row g-3 mb-4">
    <div class="col-md-6 col-xl-3">
        <div class="card stat-card info h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="stat-value"><?= number_format($stats['total_students'] ?? 0) ?></div>
                        <div class="stat-label">學生總數</div>
                    </div>
                    <div class="text-primary opacity-50">
                        <i class="bi bi-people fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-xl-3">
        <div class="card stat-card success h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="stat-value"><?= number_format($stats['active_offerings'] ?? 0) ?></div>
                        <div class="stat-label">進行中課程</div>
                    </div>
                    <div class="text-success opacity-50">
                        <i class="bi bi-journal-check fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-xl-3">
        <div class="card stat-card warning h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="stat-value"><?= number_format($stats['total_sections'] ?? 0) ?></div>
                        <div class="stat-label">班級數</div>
                    </div>
                    <div class="text-warning opacity-50">
                        <i class="bi bi-collection fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6 col-xl-3">
        <div class="card stat-card danger h-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <div class="stat-value"><?= number_format($stats['total_enrollments'] ?? 0) ?></div>
                        <div class="stat-label">選課人次</div>
                    </div>
                    <div class="text-danger opacity-50">
                        <i class="bi bi-person-check fs-1"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- 進行中的課程 -->
    <div class="col-lg-8">
        <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span><i class="bi bi-calendar-event me-2"></i>進行中的課程</span>
                <?php if ($auth->hasRole(['admin', 'staff'])): ?>
                <a href="<?= url('offerings.php') ?>" class="btn btn-sm btn-outline-primary">查看全部</a>
                <?php endif; ?>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>課程名稱</th>
                                <th>程度</th>
                                <th>班級數</th>
                                <th>學生數</th>
                                <th>期間</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($activeOfferings)): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-4">目前沒有進行中的課程</td>
                            </tr>
                            <?php else: ?>
                            <?php foreach ($activeOfferings as $offering): ?>
                            <tr>
                                <td>
                                    <a href="<?= url('offerings.php?action=view&id=' . $offering['offering_id']) ?>" class="text-decoration-none">
                                        <?= e($offering['course_name']) ?>
                                    </a>
                                    <br>
                                    <small class="text-muted"><?= e($offering['teacher_name'] ?? '-') ?></small>
                                </td>
                                <td><span class="badge bg-info"><?= e($offering['level_code']) ?></span></td>
                                <td><?= $offering['section_count'] ?? 0 ?></td>
                                <td><?= $offering['student_count'] ?? 0 ?></td>
                                <td>
                                    <small><?= formatDate($offering['start_date']) ?> ~ <?= formatDate($offering['end_date']) ?></small>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- 快捷操作 & 學生統計 -->
    <div class="col-lg-4">
        <!-- 快捷操作 -->
        <div class="card mb-4">
            <div class="card-header">
                <i class="bi bi-lightning me-2"></i>快捷操作
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <?php if ($auth->hasRole(['admin', 'staff'])): ?>
                    <a href="<?= url('offerings.php?action=create') ?>" class="btn btn-outline-primary">
                        <i class="bi bi-plus-circle me-1"></i>新增開班
                    </a>
                    <a href="<?= url('students.php?action=import') ?>" class="btn btn-outline-success">
                        <i class="bi bi-upload me-1"></i>匯入學生
                    </a>
                    <?php endif; ?>
                    <a href="<?= url('attendance.php') ?>" class="btn btn-outline-info">
                        <i class="bi bi-clipboard-check me-1"></i>點名作業
                    </a>
                    <a href="<?= url('grades.php') ?>" class="btn btn-outline-warning">
                        <i class="bi bi-journal-text me-1"></i>成績輸入
                    </a>
                </div>
            </div>
        </div>
        
        <!-- 程度分布 -->
        <div class="card">
            <div class="card-header">
                <i class="bi bi-pie-chart me-2"></i>學生程度分布
            </div>
            <div class="card-body">
                <?php if (empty($levelStats)): ?>
                <p class="text-muted text-center mb-0">暫無資料</p>
                <?php else: ?>
                <?php 
                $total = array_sum(array_column($levelStats, 'count'));
                $colors = ['primary', 'success', 'info', 'warning', 'danger', 'secondary', 'dark', 'light'];
                ?>
                <?php foreach ($levelStats as $index => $stat): ?>
                <?php $percent = $total > 0 ? round($stat['count'] / $total * 100, 1) : 0; ?>
                <div class="mb-3">
                    <div class="d-flex justify-content-between mb-1">
                        <span><?= getLevelName($stat['level_code']) ?></span>
                        <span class="text-muted"><?= $stat['count'] ?> 人 (<?= $percent ?>%)</span>
                    </div>
                    <div class="progress" style="height: 8px;">
                        <div class="progress-bar bg-<?= $colors[$index % count($colors)] ?>" 
                             style="width: <?= $percent ?>%"></div>
                    </div>
                </div>
                <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php if ($auth->isTeacher()): ?>
<!-- 教師的班級 -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-collection me-2"></i>我的班級
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>課程</th>
                                <th>班級</th>
                                <th>學生數</th>
                                <th>上課時間</th>
                                <th>操作</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($teacherSections)): ?>
                            <tr>
                                <td colspan="5" class="text-center text-muted py-4">目前沒有授課班級</td>
                            </tr>
                            <?php else: ?>
                            <?php foreach ($teacherSections as $section): ?>
                            <tr>
                                <td><?= e($section['course_name']) ?></td>
                                <td><?= e($section['section_name']) ?></td>
                                <td><?= $section['current_count'] ?> / <?= $section['max_students'] ?></td>
                                <td>
                                    <?= e($section['schedule']) ?> <?= e($section['class_time']) ?>
                                </td>
                                <td>
                                    <a href="<?= url('attendance.php?section_id=' . $section['section_id']) ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-clipboard-check"></i>
                                    </a>
                                    <a href="<?= url('grades.php?section_id=' . $section['section_id']) ?>" class="btn btn-sm btn-outline-warning">
                                        <i class="bi bi-journal-text"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
