<?php
/**
 * ISLMS - 帳號管理
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check() || !$auth->isAdmin()) {
    setFlash('error', '權限不足');
    header('Location: ' . APP_URL . '/dashboard.php');
    exit;
}

$userModel = new UserModel();
$action = $_GET['action'] ?? 'list';

// AJAX
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
    header('Content-Type: application/json; charset=utf-8');
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $ajaxAction = $_POST['action'] ?? '';
        if ($ajaxAction === 'toggle_status') {
            $id = (int) ($_POST['id'] ?? 0);
            $user = $userModel->find($id);
            if ($user && $user['user_id'] != $auth->id()) {
                $userModel->update($id, ['status' => $user['status'] ? 0 : 1]);
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'message' => '無法修改']);
            }
            exit;
        }
        if ($ajaxAction === 'reset_password') {
            $id = (int) ($_POST['id'] ?? 0);
            $newPass = 'Pass' . rand(1000, 9999);
            $userModel->changePassword($id, $newPass);
            echo json_encode(['success' => true, 'password' => $newPass]);
            exit;
        }
    }
    exit;
}

switch ($action) {
    case 'create':
    case 'edit':
        $user = null;
        $id = (int) ($_GET['id'] ?? 0);
        if ($action === 'edit' && $id) {
            $user = $userModel->find($id);
            if (!$user) {
                setFlash('error', '帳號不存在');
                header('Location: ' . APP_URL . '/users.php');
                exit;
            }
        }
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'account' => trim($_POST['account'] ?? ''),
                'name' => trim($_POST['name'] ?? ''),
                'name_en' => trim($_POST['name_en'] ?? ''),
                'email' => trim($_POST['email'] ?? ''),
                'phone' => trim($_POST['phone'] ?? ''),
                'role' => $_POST['role'] ?? 'staff',
                'status' => isset($_POST['status']) ? 1 : 0,
                'updated_by' => $auth->user()['account']
            ];
            
            $errors = [];
            if (empty($data['account'])) $errors[] = '帳號為必填';
            if (empty($data['name'])) $errors[] = '姓名為必填';
            if ($userModel->exists('account', $data['account'], $id)) $errors[] = '帳號已存在';
            
            if ($action === 'create' && empty($_POST['password'])) {
                $errors[] = '密碼為必填';
            }
            
            if (empty($errors)) {
                if ($action === 'edit') {
                    $userModel->updateUser($id, array_merge($data, ['password' => $_POST['password'] ?? '']));
                    setFlash('success', '帳號已更新');
                } else {
                    $data['password'] = $_POST['password'];
                    $userModel->createUser($data);
                    setFlash('success', '帳號已新增');
                }
                header('Location: ' . APP_URL . '/users.php');
                exit;
            }
        }
        
        $pageTitle = ($action === 'edit' ? '編輯' : '新增') . '帳號 - ' . APP_NAME;
        $breadcrumb = [['title' => '帳號管理', 'url' => url('users.php')], ['title' => $action === 'edit' ? '編輯帳號' : '新增帳號', 'active' => true]];
        
        ob_start();
        ?>
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0"><?= $action === 'edit' ? '編輯帳號' : '新增帳號' ?></h1>
        </div>
        <?php if (!empty($errors)): ?>
        <div class="alert alert-danger"><ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?></ul></div>
        <?php endif; ?>
        <div class="card">
            <div class="card-body">
                <form method="post">
                    <?= csrfField() ?>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">帳號 <span class="text-danger">*</span></label>
                            <input type="text" name="account" class="form-control" required value="<?= e($user['account'] ?? $_POST['account'] ?? '') ?>" <?= $action === 'edit' ? 'readonly' : '' ?>>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">密碼 <?= $action === 'create' ? '<span class="text-danger">*</span>' : '(留空不修改)' ?></label>
                            <input type="password" name="password" class="form-control" <?= $action === 'create' ? 'required' : '' ?>>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">中文姓名 <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" required value="<?= e($user['name'] ?? $_POST['name'] ?? '') ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">英文姓名</label>
                            <input type="text" name="name_en" class="form-control" value="<?= e($user['name_en'] ?? $_POST['name_en'] ?? '') ?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" value="<?= e($user['email'] ?? $_POST['email'] ?? '') ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">電話</label>
                            <input type="text" name="phone" class="form-control" value="<?= e($user['phone'] ?? $_POST['phone'] ?? '') ?>">
                        </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">角色</label>
                            <select name="role" class="form-select">
                                <option value="admin" <?= ($user['role'] ?? '') === 'admin' ? 'selected' : '' ?>>系統管理員</option>
                                <option value="staff" <?= ($user['role'] ?? 'staff') === 'staff' ? 'selected' : '' ?>>教務承辦</option>
                                <option value="teacher" <?= ($user['role'] ?? '') === 'teacher' ? 'selected' : '' ?>>老師</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input type="checkbox" name="status" class="form-check-input" id="status" <?= ($user['status'] ?? 1) ? 'checked' : '' ?>>
                            <label class="form-check-label" for="status">啟用</label>
                        </div>
                    </div>
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>儲存</button>
                        <a href="<?= url('users.php') ?>" class="btn btn-secondary">取消</a>
                    </div>
                </form>
            </div>
        </div>
        <?php
        $content = ob_get_clean();
        break;
        
    default:
        $users = $userModel->all('role, name');
        $pageTitle = '帳號管理 - ' . APP_NAME;
        $breadcrumb = [['title' => '帳號管理', 'active' => true]];
        
        ob_start();
        ?>
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h1 class="h3 mb-0">帳號管理</h1>
            <a href="<?= url('users.php?action=create') ?>" class="btn btn-primary"><i class="bi bi-plus-lg me-1"></i>新增帳號</a>
        </div>
        <div class="card">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover data-table mb-0">
                        <thead>
                            <tr>
                                <th>帳號</th>
                                <th>姓名</th>
                                <th>角色</th>
                                <th>Email</th>
                                <th>狀態</th>
                                <th>最後登入</th>
                                <th width="150">操作</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($users as $u): ?>
                            <tr>
                                <td><?= e($u['account']) ?></td>
                                <td><?= e($u['name']) ?></td>
                                <td><span class="badge bg-<?= $u['role'] === 'admin' ? 'danger' : ($u['role'] === 'staff' ? 'primary' : 'success') ?>"><?= getRoleName($u['role']) ?></span></td>
                                <td><?= e($u['email']) ?></td>
                                <td>
                                    <span class="badge bg-<?= $u['status'] ? 'success' : 'secondary' ?>"><?= $u['status'] ? '啟用' : '停用' ?></span>
                                </td>
                                <td><small><?= $u['last_login_at'] ? formatDateTime($u['last_login_at']) : '-' ?></small></td>
                                <td>
                                    <a href="<?= url('users.php?action=edit&id=' . $u['user_id']) ?>" class="btn btn-sm btn-outline-primary" title="編輯"><i class="bi bi-pencil"></i></a>
                                    <?php if ($u['user_id'] != $auth->id()): ?>
                                    <button class="btn btn-sm btn-outline-warning" onclick="resetPassword(<?= $u['user_id'] ?>)" title="重設密碼"><i class="bi bi-key"></i></button>
                                    <button class="btn btn-sm btn-outline-<?= $u['status'] ? 'secondary' : 'success' ?>" onclick="toggleStatus(<?= $u['user_id'] ?>)" title="<?= $u['status'] ? '停用' : '啟用' ?>">
                                        <i class="bi bi-<?= $u['status'] ? 'pause' : 'play' ?>"></i>
                                    </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <script>
        function toggleStatus(id) {
            if (!confirm('確定要切換此帳號的狀態嗎？')) return;
            $.post('<?= url('users.php') ?>', {action: 'toggle_status', id: id, <?= CSRF_TOKEN_NAME ?>: csrfToken}, function(res) {
                if (res.success) location.reload();
                else alert(res.message);
            });
        }
        function resetPassword(id) {
            if (!confirm('確定要重設此帳號的密碼嗎？')) return;
            $.post('<?= url('users.php') ?>', {action: 'reset_password', id: id, <?= CSRF_TOKEN_NAME ?>: csrfToken}, function(res) {
                if (res.success) {
                    alert('新密碼為：' + res.password + '\n請告知使用者登入後修改密碼');
                }
            });
        }
        </script>
        <?php
        $content = ob_get_clean();
}

$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
