<?php
/**
 * ISLMS - 變更密碼
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$userModel = new UserModel();
$errors = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $currentPassword = $_POST['current_password'] ?? '';
    $newPassword = $_POST['new_password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    if (empty($currentPassword)) {
        $errors[] = '請輸入目前密碼';
    } elseif (!$userModel->verifyPassword($auth->id(), $currentPassword)) {
        $errors[] = '目前密碼不正確';
    }
    
    if (empty($newPassword)) {
        $errors[] = '請輸入新密碼';
    } elseif (strlen($newPassword) < 6) {
        $errors[] = '新密碼至少需要 6 個字元';
    }
    
    if ($newPassword !== $confirmPassword) {
        $errors[] = '確認密碼不一致';
    }
    
    if (empty($errors)) {
        $userModel->changePassword($auth->id(), $newPassword);
        $success = true;
        logAudit('change_password', 'users', $auth->id());
    }
}

$pageTitle = '變更密碼 - ' . APP_NAME;
$breadcrumb = [['title' => '變更密碼', 'active' => true]];

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">變更密碼</h1>
</div>

<div class="row justify-content-center">
    <div class="col-md-6">
        <?php if ($success): ?>
        <div class="alert alert-success">
            <i class="bi bi-check-circle me-2"></i>密碼已成功變更！
        </div>
        <?php endif; ?>
        
        <?php if (!empty($errors)): ?>
        <div class="alert alert-danger">
            <ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?></ul>
        </div>
        <?php endif; ?>
        
        <div class="card">
            <div class="card-body">
                <form method="post">
                    <?= csrfField() ?>
                    <div class="mb-3">
                        <label class="form-label">目前密碼 <span class="text-danger">*</span></label>
                        <input type="password" name="current_password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">新密碼 <span class="text-danger">*</span></label>
                        <input type="password" name="new_password" class="form-control" required minlength="6">
                        <div class="form-text">密碼至少需要 6 個字元</div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">確認新密碼 <span class="text-danger">*</span></label>
                        <input type="password" name="confirm_password" class="form-control" required>
                    </div>
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>變更密碼</button>
                        <a href="<?= url('profile.php') ?>" class="btn btn-secondary">取消</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php

$content = ob_get_clean();
$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
