<?php
/**
 * ISLMS - 登入頁面
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();

// 已登入則導向儀表板
if ($auth->check()) {
    header('Location: ' . APP_URL . '/dashboard.php');
    exit;
}

$error = '';
$account = '';

// 處理登入表單
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $account = trim($_POST['account'] ?? '');
    $password = $_POST['password'] ?? '';
    
    // 驗證 CSRF
    $token = $_POST[CSRF_TOKEN_NAME] ?? '';
    if (!$token || !isset($_SESSION[CSRF_TOKEN_NAME]) || $token !== $_SESSION[CSRF_TOKEN_NAME]) {
        $error = '安全驗證失敗，請重新整理頁面';
    } elseif (empty($account) || empty($password)) {
        $error = '請輸入帳號和密碼';
    } elseif ($auth->attempt($account, $password)) {
        // 登入成功
        logAudit('login', 'users', $auth->id());
        header('Location: ' . APP_URL . '/dashboard.php');
        exit;
    } else {
        $error = '帳號或密碼錯誤';
        logAudit('login_failed', 'users', null, ['account' => $account]);
    }
}

// 顯示登入頁面
include VIEW_PATH . '/auth/login.php';
