<?php
/**
 * ISLMS - 成績管理
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$gradeModel = new GradeModel();
$sectionModel = new SectionModel();
$enrollmentModel = new EnrollmentModel();

$sectionId = (int) ($_GET['section_id'] ?? 0);

// AJAX 處理
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
    header('Content-Type: application/json; charset=utf-8');
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $ajaxAction = $_POST['action'] ?? '';
        
        if ($ajaxAction === 'save') {
            $sectionId = (int) ($_POST['section_id'] ?? 0);
            $grades = $_POST['grades'] ?? [];
            
            // 權限檢查
            if ($auth->isTeacher()) {
                $teacherSections = $sectionModel->getByTeacher($auth->id());
                if (!in_array($sectionId, array_column($teacherSections, 'section_id'))) {
                    echo json_encode(['success' => false, 'message' => '權限不足']);
                    exit;
                }
            }
            
            try {
                $gradeModel->saveGrades($sectionId, $grades, $auth->id());
                echo json_encode(['success' => true, 'message' => '成績已儲存']);
            } catch (Exception $e) {
                echo json_encode(['success' => false, 'message' => $e->getMessage()]);
            }
            exit;
        }
        
        if ($ajaxAction === 'calculate_all') {
            $sectionId = (int) ($_POST['section_id'] ?? 0);
            $students = $sectionModel->getStudents($sectionId);
            
            foreach ($students as $s) {
                $enrollmentModel->calculateFinalScore($s['enrollment_id']);
                $enrollmentModel->calculateAttendanceRate($s['enrollment_id']);
            }
            
            echo json_encode(['success' => true, 'message' => '已重新計算所有成績']);
            exit;
        }
    }
    exit;
}

if ($sectionId) {
    $section = $sectionModel->getWithDetails($sectionId);
    
    if (!$section) {
        setFlash('error', '班級不存在');
        header('Location: ' . APP_URL . '/grades.php');
        exit;
    }
    
    // 教師權限檢查
    if ($auth->isTeacher()) {
        $teacherSections = $sectionModel->getByTeacher($auth->id());
        if (!in_array($sectionId, array_column($teacherSections, 'section_id'))) {
            setFlash('error', '您沒有權限操作此班級');
            header('Location: ' . APP_URL . '/grades.php');
            exit;
        }
    }
    
    $gradeData = $gradeModel->getSectionGrades($sectionId);
    
    $pageTitle = '成績管理 - ' . $section['section_name'] . ' - ' . APP_NAME;
    $breadcrumb = [
        ['title' => '成績管理', 'url' => url('grades.php')],
        ['title' => $section['course_name'] . ' ' . $section['section_name'], 'active' => true]
    ];
    
    ob_start();
    include VIEW_PATH . '/grades/entry.php';
    $content = ob_get_clean();
} else {
    // 班級選擇
    if ($auth->isTeacher()) {
        $sections = $sectionModel->getByTeacher($auth->id());
    } else {
        $sql = "SELECT s.*, o.semester, c.course_name, c.level_code, u.name as teacher_name
                FROM sections s
                LEFT JOIN offerings o ON s.offering_id = o.offering_id
                LEFT JOIN courses c ON o.course_id = c.course_id
                LEFT JOIN users u ON COALESCE(s.teacher_id, o.teacher_id) = u.user_id
                WHERE o.offering_status = 'active' AND s.section_status = 'active'
                ORDER BY c.course_name, s.section_name";
        $sections = Database::getInstance()->fetchAll($sql);
    }
    
    $pageTitle = '成績管理 - ' . APP_NAME;
    $breadcrumb = [['title' => '成績管理', 'active' => true]];
    
    ob_start();
    include VIEW_PATH . '/grades/index.php';
    $content = ob_get_clean();
}

$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
