<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0"><?= e($section['course_name']) ?> - <?= e($section['section_name']) ?></h1>
    <div>
        <a href="<?= url('attendance.php?section_id=' . $section['section_id']) ?>" class="btn btn-primary">
            <i class="bi bi-clipboard-check me-1"></i>點名
        </a>
        <a href="<?= url('grades.php?section_id=' . $section['section_id']) ?>" class="btn btn-warning">
            <i class="bi bi-journal-text me-1"></i>成績
        </a>
    </div>
</div>

<!-- 班級資訊 -->
<div class="card mb-4">
    <div class="card-header"><i class="bi bi-info-circle me-2"></i>班級資訊</div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3 mb-2">
                <label class="text-muted small">程度</label>
                <div><span class="badge bg-info"><?= getLevelName($section['level_code']) ?></span></div>
            </div>
            <div class="col-md-3 mb-2">
                <label class="text-muted small">授課教師</label>
                <div class="fw-bold"><?= e($section['teacher_name'] ?? '-') ?></div>
            </div>
            <div class="col-md-3 mb-2">
                <label class="text-muted small">教室</label>
                <div><?= e($section['classroom'] ?? '-') ?></div>
            </div>
            <div class="col-md-3 mb-2">
                <label class="text-muted small">人數</label>
                <div><span class="badge bg-<?= $section['current_count'] >= $section['max_students'] ? 'danger' : 'success' ?> fs-6"><?= $section['current_count'] ?> / <?= $section['max_students'] ?></span></div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3 mb-2">
                <label class="text-muted small">課程期間</label>
                <div><?= formatDate($section['start_date']) ?> ~ <?= formatDate($section['end_date']) ?></div>
            </div>
            <div class="col-md-3 mb-2">
                <label class="text-muted small">上課時間</label>
                <div><?= e($section['schedule']) ?> <?= e($section['class_time']) ?></div>
            </div>
        </div>
    </div>
</div>

<!-- 學生名單 -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span><i class="bi bi-people me-2"></i>學生名單</span>
        <?php if ($auth->hasRole(['admin', 'staff'])): ?>
        <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#addStudentModal">
            <i class="bi bi-plus-lg me-1"></i>加入學生
        </button>
        <?php endif; ?>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                    <tr>
                        <th width="50">#</th>
                        <th>學號</th>
                        <th>姓名</th>
                        <th>國籍</th>
                        <th>出席率</th>
                        <th>成績</th>
                        <th>狀態</th>
                        <?php if ($auth->hasRole(['admin', 'staff'])): ?>
                        <th width="100">操作</th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; foreach ($students as $s): ?>
                    <tr class="<?= $s['enrollment_status'] !== 'active' ? 'table-secondary' : '' ?>">
                        <td><?= $i++ ?></td>
                        <td><?= e($s['student_no']) ?></td>
                        <td>
                            <?= e($s['name']) ?>
                            <?php if ($s['chinese_name']): ?>
                            <br><small class="text-muted"><?= e($s['chinese_name']) ?></small>
                            <?php endif; ?>
                        </td>
                        <td><?= e($s['nationality']) ?></td>
                        <td><?= $s['attendance_rate'] !== null ? $s['attendance_rate'] . '%' : '-' ?></td>
                        <td>
                            <?php if ($s['final_score'] !== null): ?>
                            <?= $s['final_score'] ?> (<?= $s['final_grade'] ?>)
                            <?php else: ?>
                            -
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php $est = getEnrollmentStatus($s['enrollment_status']); ?>
                            <span class="badge bg-<?= $est['class'] ?>"><?= $est['name'] ?></span>
                        </td>
                        <?php if ($auth->hasRole(['admin', 'staff'])): ?>
                        <td>
                            <?php if ($s['enrollment_status'] === 'active'): ?>
                            <?php if (!empty($otherSections)): ?>
                            <button type="button" class="btn btn-sm btn-outline-info" onclick="showTransfer(<?= $s['enrollment_id'] ?>, '<?= e($s['name']) ?>')" title="調班">
                                <i class="bi bi-arrow-left-right"></i>
                            </button>
                            <?php endif; ?>
                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="dropStudent(<?= $s['enrollment_id'] ?>, '<?= e($s['name']) ?>')" title="退選">
                                <i class="bi bi-x-circle"></i>
                            </button>
                            <?php endif; ?>
                        </td>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($students)): ?>
                    <tr><td colspan="<?= $auth->hasRole(['admin', 'staff']) ? 8 : 7 ?>" class="text-center text-muted py-4">尚無學生</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php if ($auth->hasRole(['admin', 'staff'])): ?>
<!-- 加入學生 Modal -->
<div class="modal fade" id="addStudentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">加入學生</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <input type="text" id="searchStudent" class="form-control" placeholder="輸入學號或姓名搜尋...">
                </div>
                <div id="searchResults" class="list-group" style="max-height: 300px; overflow-y: auto;"></div>
            </div>
        </div>
    </div>
</div>

<!-- 調班 Modal -->
<div class="modal fade" id="transferModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">調班</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>學生：<strong id="transferStudentName"></strong></p>
                <input type="hidden" id="transferEnrollmentId">
                <div class="mb-3">
                    <label class="form-label">目標班級</label>
                    <select id="transferToSection" class="form-select">
                        <?php foreach ($otherSections as $os): ?>
                        <option value="<?= $os['section_id'] ?>"><?= e($os['section_name']) ?> (<?= $os['current_count'] ?>/<?= $os['max_students'] ?>)</option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">原因</label>
                    <input type="text" id="transferReason" class="form-control">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">取消</button>
                <button type="button" class="btn btn-primary" onclick="doTransfer()">確定調班</button>
            </div>
        </div>
    </div>
</div>

<script>
const sectionId = <?= $section['section_id'] ?>;

// 搜尋學生
let searchTimer;
$('#searchStudent').on('input', function() {
    clearTimeout(searchTimer);
    const keyword = $(this).val().trim();
    if (keyword.length < 1) {
        $('#searchResults').empty();
        return;
    }
    searchTimer = setTimeout(() => {
        $.post('<?= url('sections.php') ?>', {
            action: 'search_students',
            keyword: keyword,
            section_id: sectionId,
            <?= CSRF_TOKEN_NAME ?>: csrfToken
        }, function(res) {
            const $results = $('#searchResults').empty();
            if (res.data && res.data.length > 0) {
                res.data.forEach(s => {
                    $results.append(`
                        <button type="button" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center" onclick="addStudent(${s.student_id})">
                            <div>
                                <strong>${s.student_no}</strong> - ${s.name}
                                ${s.chinese_name ? '<br><small class="text-muted">' + s.chinese_name + '</small>' : ''}
                            </div>
                            <span class="badge bg-info">${s.level_code}</span>
                        </button>
                    `);
                });
            } else {
                $results.append('<div class="text-muted text-center py-3">沒有符合的學生</div>');
            }
        });
    }, 300);
});

function addStudent(studentId) {
    if (!confirm('確定要加入此學生嗎？')) return;
    $.post('<?= url('sections.php') ?>', {
        action: 'add_student',
        section_id: sectionId,
        student_id: studentId,
        <?= CSRF_TOKEN_NAME ?>: csrfToken
    }, function(res) {
        alert(res.message);
        if (res.success) location.reload();
    });
}

function showTransfer(enrollmentId, name) {
    $('#transferEnrollmentId').val(enrollmentId);
    $('#transferStudentName').text(name);
    $('#transferReason').val('');
    new bootstrap.Modal('#transferModal').show();
}

function doTransfer() {
    $.post('<?= url('sections.php') ?>', {
        action: 'transfer',
        enrollment_id: $('#transferEnrollmentId').val(),
        to_section_id: $('#transferToSection').val(),
        reason: $('#transferReason').val(),
        <?= CSRF_TOKEN_NAME ?>: csrfToken
    }, function(res) {
        alert(res.message);
        if (res.success) location.reload();
    });
}

function dropStudent(enrollmentId, name) {
    const reason = prompt('請輸入退選原因（可選）：');
    if (reason === null) return;
    if (!confirm(`確定要將 ${name} 退選嗎？`)) return;
    $.post('<?= url('sections.php') ?>', {
        action: 'drop',
        enrollment_id: enrollmentId,
        reason: reason,
        <?= CSRF_TOKEN_NAME ?>: csrfToken
    }, function(res) {
        alert(res.message);
        if (res.success) location.reload();
    });
}
</script>
<?php endif; ?>
