<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">班級管理</h1>
</div>

<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover data-table mb-0">
                <thead>
                    <tr>
                        <th>課程名稱</th>
                        <th>班級</th>
                        <th>程度</th>
                        <th>授課教師</th>
                        <th>人數</th>
                        <th>上課時間</th>
                        <th width="150">操作</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($sections)): ?>
                    <tr><td colspan="7" class="text-center text-muted py-4">目前沒有班級</td></tr>
                    <?php else: ?>
                    <?php foreach ($sections as $s): ?>
                    <tr>
                        <td><?= e($s['course_name']) ?></td>
                        <td><strong><?= e($s['section_name']) ?></strong></td>
                        <td><span class="badge bg-info"><?= e($s['level_code']) ?></span></td>
                        <td><?= e($s['teacher_name'] ?? '-') ?></td>
                        <td>
                            <span class="badge bg-<?= $s['current_count'] >= $s['max_students'] ? 'danger' : 'success' ?>">
                                <?= $s['current_count'] ?> / <?= $s['max_students'] ?>
                            </span>
                        </td>
                        <td><small><?= e($s['schedule'] ?? '') ?> <?= e($s['class_time'] ?? '') ?></small></td>
                        <td>
                            <a href="<?= url('sections.php?action=view&id=' . $s['section_id']) ?>" class="btn btn-sm btn-outline-info" title="名單"><i class="bi bi-people"></i></a>
                            <a href="<?= url('attendance.php?section_id=' . $s['section_id']) ?>" class="btn btn-sm btn-outline-primary" title="點名"><i class="bi bi-clipboard-check"></i></a>
                            <a href="<?= url('grades.php?section_id=' . $s['section_id']) ?>" class="btn btn-sm btn-outline-warning" title="成績"><i class="bi bi-journal-text"></i></a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
