<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">統計報表</h1>
</div>

<ul class="nav nav-tabs mb-4">
    <li class="nav-item">
        <a class="nav-link <?= $reportType === 'attendance' ? 'active' : '' ?>" href="<?= url('reports.php?type=attendance') ?>">
            <i class="bi bi-clipboard-check me-1"></i>出席統計
        </a>
    </li>
    <li class="nav-item">
        <a class="nav-link <?= $reportType === 'grades' ? 'active' : '' ?>" href="<?= url('reports.php?type=grades') ?>">
            <i class="bi bi-journal-text me-1"></i>成績統計
        </a>
    </li>
</ul>

<div class="card mb-4">
    <div class="card-body">
        <form method="get" class="row g-3">
            <input type="hidden" name="type" value="<?= e($reportType) ?>">
            <div class="col-md-3">
                <label class="form-label">課程</label>
                <select name="offering_id" class="form-select">
                    <option value="">全部課程</option>
                    <?php foreach ($offerings as $o): ?>
                    <option value="<?= $o['offering_id'] ?>" <?= $filters['offering_id'] == $o['offering_id'] ? 'selected' : '' ?>>
                        <?= e($o['course_name']) ?> (<?= e($o['semester']) ?>)
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">程度</label>
                <select name="level_code" class="form-select">
                    <option value="">全部</option>
                    <?php foreach ($levels as $l): ?>
                    <option value="<?= e($l['level_code']) ?>" <?= $filters['level_code'] === $l['level_code'] ? 'selected' : '' ?>><?= e($l['level_name']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php if ($reportType === 'attendance'): ?>
            <div class="col-md-2">
                <label class="form-label">開始日期</label>
                <input type="date" name="start_date" class="form-control" value="<?= e($filters['start_date']) ?>">
            </div>
            <div class="col-md-2">
                <label class="form-label">結束日期</label>
                <input type="date" name="end_date" class="form-control" value="<?= e($filters['end_date']) ?>">
            </div>
            <?php endif; ?>
            <div class="col-auto d-flex align-items-end">
                <button type="submit" class="btn btn-primary me-2"><i class="bi bi-search me-1"></i>查詢</button>
                <a href="<?= url('reports.php?type=' . $reportType) ?>" class="btn btn-outline-secondary me-2">清除</a>
                <a href="<?= url('reports.php?' . http_build_query(array_merge($_GET, ['export' => 'csv']))) ?>" class="btn btn-success">
                    <i class="bi bi-download me-1"></i>匯出
                </a>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <i class="bi bi-table me-2"></i><?= $reportType === 'attendance' ? '出席統計' : '成績統計' ?>
        <span class="badge bg-secondary ms-2"><?= count($reportData) ?> 筆</span>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <?php if ($reportType === 'attendance'): ?>
            <table class="table table-hover data-table mb-0">
                <thead>
                    <tr>
                        <th>學號</th>
                        <th>姓名</th>
                        <th>課程</th>
                        <th>班級</th>
                        <th class="text-center">總堂</th>
                        <th class="text-center">出席</th>
                        <th class="text-center">遲到</th>
                        <th class="text-center">缺席</th>
                        <th class="text-center">請假</th>
                        <th class="text-center">出席率</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($reportData as $row): ?>
                    <tr>
                        <td><?= e($row['student_no']) ?></td>
                        <td><?= e($row['student_name']) ?></td>
                        <td><?= e($row['course_name']) ?></td>
                        <td><?= e($row['section_name']) ?></td>
                        <td class="text-center"><?= $row['total_classes'] ?></td>
                        <td class="text-center text-success"><?= $row['present'] ?></td>
                        <td class="text-center text-warning"><?= $row['late'] ?></td>
                        <td class="text-center text-danger"><?= $row['absent'] ?></td>
                        <td class="text-center"><?= $row['leave_count'] ?></td>
                        <td class="text-center">
                            <span class="badge bg-<?= $row['attendance_rate'] >= 80 ? 'success' : ($row['attendance_rate'] >= 60 ? 'warning' : 'danger') ?>"><?= $row['attendance_rate'] ?>%</span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php else: ?>
            <table class="table table-hover data-table mb-0">
                <thead>
                    <tr>
                        <th>學號</th>
                        <th>姓名</th>
                        <th>課程</th>
                        <th>班級</th>
                        <th class="text-center">總分</th>
                        <th class="text-center">等第</th>
                        <th class="text-center">出席率</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($reportData as $row): ?>
                    <tr>
                        <td><?= e($row['student_no']) ?></td>
                        <td><?= e($row['student_name']) ?></td>
                        <td><?= e($row['course_name']) ?></td>
                        <td><?= e($row['section_name']) ?></td>
                        <td class="text-center fw-bold"><?= $row['final_score'] !== null ? number_format($row['final_score'], 1) : '-' ?></td>
                        <td class="text-center">
                            <?php if ($row['final_grade']): ?>
                            <span class="badge bg-<?= $row['final_grade'] === 'A' ? 'success' : ($row['final_grade'] === 'B' ? 'primary' : ($row['final_grade'] === 'C' ? 'warning' : 'danger')) ?>"><?= $row['final_grade'] ?></span>
                            <?php else: ?>-<?php endif; ?>
                        </td>
                        <td class="text-center"><?= $row['attendance_rate'] ? $row['attendance_rate'] . '%' : '-' ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
    </div>
</div>
