<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">開班管理</h1>
    <?php if ($auth->hasRole(['admin', 'staff'])): ?>
    <a href="<?= url('offerings.php?action=create') ?>" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>新增開班
    </a>
    <?php endif; ?>
</div>

<div class="card mb-4">
    <div class="card-body">
        <form method="get" class="row g-3">
            <div class="col-md-3">
                <select name="semester" class="form-select">
                    <option value="">全部學期</option>
                    <?php foreach ($semesters as $s): ?>
                    <option value="<?= e($s['semester']) ?>" <?= $semester === $s['semester'] ? 'selected' : '' ?>>
                        <?= e($s['semester']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-3">
                <select name="status" class="form-select">
                    <option value="">全部狀態</option>
                    <option value="draft" <?= $status === 'draft' ? 'selected' : '' ?>>草稿</option>
                    <option value="active" <?= $status === 'active' ? 'selected' : '' ?>>進行中</option>
                    <option value="closed" <?= $status === 'closed' ? 'selected' : '' ?>>已結束</option>
                </select>
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-outline-primary"><i class="bi bi-search me-1"></i>篩選</button>
                <a href="<?= url('offerings.php') ?>" class="btn btn-outline-secondary">清除</a>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover data-table mb-0">
                <thead>
                    <tr>
                        <th>學期</th>
                        <th>課程名稱</th>
                        <th>程度</th>
                        <th>授課教師</th>
                        <th>班級/學生</th>
                        <th>課程期間</th>
                        <th>狀態</th>
                        <th width="100">操作</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($offerings as $o): ?>
                    <tr>
                        <td><?= e($o['semester']) ?></td>
                        <td>
                            <a href="<?= url('offerings.php?action=view&id=' . $o['offering_id']) ?>" class="text-decoration-none fw-bold">
                                <?= e($o['course_name']) ?>
                            </a>
                        </td>
                        <td><span class="badge bg-info"><?= e($o['level_code']) ?></span></td>
                        <td><?= e($o['teacher_name'] ?? '-') ?></td>
                        <td>
                            <span class="badge bg-secondary"><?= $o['section_count'] ?> 班</span>
                            <span class="badge bg-primary"><?= $o['student_count'] ?> 人</span>
                        </td>
                        <td><small><?= formatDate($o['start_date']) ?> ~ <?= formatDate($o['end_date']) ?></small></td>
                        <td>
                            <?php $st = getOfferingStatus($o['offering_status']); ?>
                            <span class="badge bg-<?= $st['class'] ?>"><?= $st['name'] ?></span>
                        </td>
                        <td>
                            <a href="<?= url('offerings.php?action=view&id=' . $o['offering_id']) ?>" class="btn btn-sm btn-outline-info" title="查看"><i class="bi bi-eye"></i></a>
                            <?php if ($auth->hasRole(['admin', 'staff'])): ?>
                            <a href="<?= url('offerings.php?action=edit&id=' . $o['offering_id']) ?>" class="btn btn-sm btn-outline-primary" title="編輯"><i class="bi bi-pencil"></i></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
