<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0"><?= e($section['course_name']) ?> - <?= e($section['section_name']) ?></h1>
        <small class="text-muted">成績輸入</small>
    </div>
    <div>
        <button type="button" class="btn btn-info" onclick="calculateAll()">
            <i class="bi bi-calculator me-1"></i>重新計算
        </button>
        <button type="button" class="btn btn-primary" onclick="saveGrades()">
            <i class="bi bi-save me-1"></i>儲存成績
        </button>
        <a href="<?= url('grades.php') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-1"></i>返回
        </a>
    </div>
</div>

<?php if (empty($gradeData['students'])): ?>
<div class="alert alert-warning">此班級尚無學生</div>
<?php else: ?>

<!-- 評分項目說明 -->
<div class="card mb-4">
    <div class="card-body py-2">
        <strong>評分項目：</strong>
        <?php foreach ($gradeData['items'] as $item): ?>
        <span class="badge bg-secondary me-2"><?= e($item['item_name']) ?> (<?= $item['weight'] ?>%)</span>
        <?php endforeach; ?>
        <span class="badge bg-dark">總分 = Σ(項目分數 × 權重)</span>
    </div>
</div>

<div class="card">
    <div class="card-body p-0">
        <form id="gradeForm">
            <div class="table-responsive">
                <table class="table table-hover table-bordered mb-0">
                    <thead class="table-light">
                        <tr>
                            <th width="50">#</th>
                            <th width="100">學號</th>
                            <th width="150">姓名</th>
                            <?php foreach ($gradeData['items'] as $item): ?>
                            <th width="100" class="text-center">
                                <?= e($item['item_name']) ?><br>
                                <small class="text-muted">(<?= $item['weight'] ?>%)</small>
                            </th>
                            <?php endforeach; ?>
                            <th width="80" class="text-center bg-light">總分</th>
                            <th width="60" class="text-center bg-light">等第</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; foreach ($gradeData['students'] as $s): ?>
                        <tr>
                            <td><?= $i++ ?></td>
                            <td><?= e($s['student_no']) ?></td>
                            <td>
                                <?= e($s['name']) ?>
                                <?php if ($s['chinese_name']): ?>
                                <br><small class="text-muted"><?= e($s['chinese_name']) ?></small>
                                <?php endif; ?>
                            </td>
                            <?php foreach ($gradeData['items'] as $item): ?>
                            <?php $grade = $s['grades'][$item['item_id']] ?? null; ?>
                            <td class="text-center p-1">
                                <input type="number" 
                                       class="form-control form-control-sm text-center grade-input"
                                       name="grades[<?= $s['enrollment_id'] ?>][<?= $item['item_id'] ?>]"
                                       value="<?= $grade['score'] ?? '' ?>"
                                       min="0" max="<?= $item['max_score'] ?>" step="0.1"
                                       data-enrollment="<?= $s['enrollment_id'] ?>"
                                       data-weight="<?= $item['weight'] ?>">
                            </td>
                            <?php endforeach; ?>
                            <td class="text-center bg-light fw-bold final-score" data-enrollment="<?= $s['enrollment_id'] ?>">
                                <?= $s['final_score'] !== null ? number_format($s['final_score'], 1) : '-' ?>
                            </td>
                            <td class="text-center bg-light">
                                <span class="badge bg-<?= getGradeBadgeClass($s['final_grade'] ?? '') ?> final-grade" data-enrollment="<?= $s['enrollment_id'] ?>">
                                    <?= $s['final_grade'] ?? '-' ?>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </form>
    </div>
</div>

<!-- 等第說明 -->
<div class="card mt-3">
    <div class="card-body py-2">
        <small class="text-muted">
            <strong>等第標準：</strong>
            <span class="badge bg-success">A: 80-100</span>
            <span class="badge bg-primary">B: 70-79</span>
            <span class="badge bg-warning text-dark">C: 60-69</span>
            <span class="badge bg-danger">D: 60以下</span>
        </small>
    </div>
</div>

<?php endif; ?>

<?php
function getGradeBadgeClass($grade) {
    switch ($grade) {
        case 'A': return 'success';
        case 'B': return 'primary';
        case 'C': return 'warning';
        case 'D': return 'danger';
        default: return 'secondary';
    }
}
?>

<script>
const sectionId = <?= $sectionId ?>;

// 即時計算總分
$('.grade-input').on('input', function() {
    const enrollmentId = $(this).data('enrollment');
    calculateTotal(enrollmentId);
});

function calculateTotal(enrollmentId) {
    let total = 0;
    let hasValue = false;
    
    $(`.grade-input[data-enrollment="${enrollmentId}"]`).each(function() {
        const score = parseFloat($(this).val());
        const weight = parseFloat($(this).data('weight'));
        if (!isNaN(score)) {
            total += score * weight / 100;
            hasValue = true;
        }
    });
    
    if (hasValue) {
        $(`.final-score[data-enrollment="${enrollmentId}"]`).text(total.toFixed(1));
        const grade = getGradeLetter(total);
        $(`.final-grade[data-enrollment="${enrollmentId}"]`)
            .text(grade)
            .removeClass('bg-success bg-primary bg-warning bg-danger bg-secondary')
            .addClass('bg-' + getGradeClass(grade));
    }
}

function getGradeLetter(score) {
    if (score >= 80) return 'A';
    if (score >= 70) return 'B';
    if (score >= 60) return 'C';
    return 'D';
}

function getGradeClass(grade) {
    switch (grade) {
        case 'A': return 'success';
        case 'B': return 'primary';
        case 'C': return 'warning';
        case 'D': return 'danger';
        default: return 'secondary';
    }
}

function saveGrades() {
    const formData = $('#gradeForm').serialize();
    
    $.post('<?= url('grades.php') ?>', formData + '&action=save&section_id=' + sectionId + '&<?= CSRF_TOKEN_NAME ?>=' + csrfToken, function(res) {
        if (res.success) {
            showToast(res.message, 'success');
        } else {
            alert(res.message);
        }
    });
}

function calculateAll() {
    if (!confirm('確定要重新計算所有學生的總分和出席率嗎？')) return;
    
    $.post('<?= url('grades.php') ?>', {
        action: 'calculate_all',
        section_id: sectionId,
        <?= CSRF_TOKEN_NAME ?>: csrfToken
    }, function(res) {
        if (res.success) {
            showToast(res.message, 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            alert(res.message);
        }
    });
}

// Tab 鍵快速切換
$('.grade-input').on('keydown', function(e) {
    if (e.key === 'Tab') {
        // 預設行為
    }
});

// Ctrl+S 儲存
$(document).keydown(function(e) {
    if (e.ctrlKey && e.key === 's') {
        e.preventDefault();
        saveGrades();
    }
});
</script>
