<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>登入 - <?= APP_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #1a365d 0%, #2c5282 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: "Microsoft JhengHei", "Noto Sans TC", sans-serif;
        }
        
        .login-container {
            width: 100%;
            max-width: 420px;
            padding: 1rem;
        }
        
        .login-card {
            background: #fff;
            border-radius: 1rem;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        
        .login-header {
            background: #f8fafc;
            padding: 2rem;
            text-align: center;
            border-bottom: 1px solid #e2e8f0;
        }
        
        .login-header h1 {
            color: #1a365d;
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.25rem;
        }
        
        .login-header p {
            color: #718096;
            margin: 0;
            font-size: 0.875rem;
        }
        
        .login-body {
            padding: 2rem;
        }
        
        .form-floating > label {
            color: #718096;
        }
        
        .form-control:focus {
            border-color: #2c5282;
            box-shadow: 0 0 0 0.2rem rgba(44, 82, 130, 0.15);
        }
        
        .btn-login {
            background: #2c5282;
            border: none;
            padding: 0.75rem;
            font-weight: 600;
        }
        
        .btn-login:hover {
            background: #1a365d;
        }
        
        .login-footer {
            text-align: center;
            padding: 1rem;
            background: #f8fafc;
            border-top: 1px solid #e2e8f0;
            color: #718096;
            font-size: 0.875rem;
        }
        
        .logo-icon {
            font-size: 3rem;
            color: #2c5282;
            margin-bottom: 0.5rem;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <i class="bi bi-mortarboard-fill logo-icon"></i>
                <h1><?= APP_NAME ?></h1>
                <p><?= APP_NAME_EN ?></p>
            </div>
            
            <div class="login-body">
                <?php if (!empty($error)): ?>
                <div class="alert alert-danger d-flex align-items-center" role="alert">
                    <i class="bi bi-exclamation-triangle-fill me-2"></i>
                    <div><?= e($error) ?></div>
                </div>
                <?php endif; ?>
                
                <form method="post" action="">
                    <?= csrfField() ?>
                    
                    <div class="form-floating mb-3">
                        <input type="text" class="form-control" id="account" name="account" 
                               placeholder="帳號" value="<?= e($account ?? '') ?>" required autofocus>
                        <label for="account"><i class="bi bi-person me-1"></i>帳號</label>
                    </div>
                    
                    <div class="form-floating mb-4">
                        <input type="password" class="form-control" id="password" name="password" 
                               placeholder="密碼" required>
                        <label for="password"><i class="bi bi-lock me-1"></i>密碼</label>
                    </div>
                    
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary btn-login">
                            <i class="bi bi-box-arrow-in-right me-1"></i>登入系統
                        </button>
                    </div>
                </form>
            </div>
            
            <div class="login-footer">
                <i class="bi bi-shield-check me-1"></i>
                華語教學中心 Chinese Language Center
            </div>
        </div>
        
        <div class="text-center mt-3 text-white-50">
            <small>&copy; <?= date('Y') ?> <?= APP_NAME ?> v<?= APP_VERSION ?></small>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
