<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h1 class="h3 mb-0"><?= e($section['course_name']) ?> - <?= e($section['section_name']) ?></h1>
        <small class="text-muted"><?= e($section['schedule']) ?> <?= e($section['class_time']) ?></small>
    </div>
    <div>
        <a href="<?= url('attendance.php') ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left me-1"></i>返回
        </a>
    </div>
</div>

<div class="row">
    <!-- 左側：點名日期選擇 -->
    <div class="col-md-3 mb-4">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-calendar3 me-2"></i>點名日期
            </div>
            <div class="card-body">
                <div class="mb-3">
                    <input type="date" id="selectDate" class="form-control" value="<?= e($classDate) ?>">
                </div>
                <button type="button" class="btn btn-primary w-100 mb-3" onclick="loadDate()">
                    <i class="bi bi-search me-1"></i>查看/新增
                </button>
                
                <?php if (!empty($dates)): ?>
                <hr>
                <div class="small text-muted mb-2">已點名日期：</div>
                <div class="list-group list-group-flush" style="max-height: 300px; overflow-y: auto;">
                    <?php foreach ($dates as $d): ?>
                    <a href="<?= url('attendance.php?section_id=' . $sectionId . '&date=' . $d['class_date']) ?>" 
                       class="list-group-item list-group-item-action d-flex justify-content-between align-items-center <?= $d['class_date'] === $classDate ? 'active' : '' ?>">
                        <?= formatDate($d['class_date'], 'm/d') ?>
                        <?php if ($d['is_locked']): ?>
                        <i class="bi bi-lock-fill text-warning"></i>
                        <?php endif; ?>
                    </a>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- 右側：點名表 -->
    <div class="col-md-9">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span>
                    <i class="bi bi-clipboard-check me-2"></i>
                    <?= formatDate($classDate, 'Y年m月d日') ?> 點名表
                    <?php if ($isLocked): ?>
                    <span class="badge bg-warning ms-2"><i class="bi bi-lock-fill"></i> 已鎖定</span>
                    <?php endif; ?>
                </span>
                <div>
                    <?php if (!$isLocked): ?>
                    <button type="button" class="btn btn-sm btn-success" onclick="setAllPresent()">
                        <i class="bi bi-check-all me-1"></i>全部出席
                    </button>
                    <button type="button" class="btn btn-sm btn-primary" onclick="saveAttendance()">
                        <i class="bi bi-save me-1"></i>儲存
                    </button>
                    <?php endif; ?>
                    <?php if ($auth->hasRole(['admin', 'staff'])): ?>
                    <?php if ($isLocked): ?>
                    <button type="button" class="btn btn-sm btn-warning" onclick="unlockDate()">
                        <i class="bi bi-unlock me-1"></i>解鎖
                    </button>
                    <?php else: ?>
                    <button type="button" class="btn btn-sm btn-outline-warning" onclick="lockDate()">
                        <i class="bi bi-lock me-1"></i>鎖定
                    </button>
                    <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body p-0">
                <?php if (empty($students)): ?>
                <div class="text-center text-muted py-5">此班級尚無學生</div>
                <?php else: ?>
                <form id="attendanceForm">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>學號</th>
                                    <th>姓名</th>
                                    <th width="300">出席狀態</th>
                                    <th>備註</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i = 1; foreach ($students as $s): ?>
                                <?php $record = $recordMap[$s['student_id']] ?? null; ?>
                                <tr>
                                    <td><?= $i++ ?></td>
                                    <td><?= e($s['student_no']) ?></td>
                                    <td>
                                        <?= e($s['name']) ?>
                                        <?php if ($s['chinese_name']): ?>
                                        <br><small class="text-muted"><?= e($s['chinese_name']) ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm attendance-btns" role="group" data-student="<?= $s['student_id'] ?>">
                                            <?php
                                            $statuses = [
                                                'P' => ['出席', 'success'],
                                                'L' => ['遲到', 'warning'],
                                                'A' => ['缺席', 'danger'],
                                                'E' => ['請假', 'info'],
                                                'O' => ['公假', 'primary'],
                                                'S' => ['病假', 'secondary']
                                            ];
                                            $currentStatus = $record['attendance_status'] ?? 'P';
                                            foreach ($statuses as $code => $info):
                                            ?>
                                            <button type="button" 
                                                    class="btn btn-<?= $currentStatus === $code ? '' : 'outline-' ?><?= $info[1] ?>"
                                                    data-status="<?= $code ?>"
                                                    <?= $isLocked ? 'disabled' : '' ?>
                                                    onclick="setStatus(<?= $s['student_id'] ?>, '<?= $code ?>', this)">
                                                <?= $info[0] ?>
                                            </button>
                                            <?php endforeach; ?>
                                        </div>
                                        <input type="hidden" name="attendance[<?= $s['student_id'] ?>][status]" value="<?= $currentStatus ?>">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control form-control-sm" 
                                               name="attendance[<?= $s['student_id'] ?>][note]"
                                               value="<?= e($record['note'] ?? '') ?>"
                                               <?= $isLocked ? 'readonly' : '' ?>
                                               placeholder="備註">
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </form>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- 出席狀態說明 -->
        <div class="card mt-3">
            <div class="card-body py-2">
                <small class="text-muted">
                    <strong>狀態說明：</strong>
                    <span class="badge bg-success">P 出席</span>
                    <span class="badge bg-warning">L 遲到</span>
                    <span class="badge bg-danger">A 缺席</span>
                    <span class="badge bg-info">E 請假</span>
                    <span class="badge bg-primary">O 公假</span>
                    <span class="badge bg-secondary">S 病假</span>
                </small>
            </div>
        </div>
    </div>
</div>

<script>
const sectionId = <?= $sectionId ?>;
const classDate = '<?= $classDate ?>';
const isLocked = <?= $isLocked ? 'true' : 'false' ?>;

function loadDate() {
    const date = $('#selectDate').val();
    if (date) {
        window.location.href = '<?= url('attendance.php?section_id=' . $sectionId) ?>&date=' + date;
    }
}

function setStatus(studentId, status, btn) {
    if (isLocked) return;
    
    // 更新按鈕樣式
    const $group = $(btn).closest('.btn-group');
    $group.find('button').each(function() {
        const s = $(this).data('status');
        const baseClass = $(this).attr('class').match(/btn-(outline-)?(success|warning|danger|info|primary|secondary)/);
        if (baseClass) {
            const color = baseClass[2];
            if (s === status) {
                $(this).removeClass('btn-outline-' + color).addClass('btn-' + color);
            } else {
                $(this).removeClass('btn-' + color).addClass('btn-outline-' + color);
            }
        }
    });
    
    // 更新隱藏欄位
    $(`input[name="attendance[${studentId}][status]"]`).val(status);
}

function setAllPresent() {
    if (isLocked) return;
    $('.attendance-btns').each(function() {
        const studentId = $(this).data('student');
        const btn = $(this).find('[data-status="P"]')[0];
        setStatus(studentId, 'P', btn);
    });
    showToast('已設定全部出席', 'success');
}

function saveAttendance() {
    if (isLocked) {
        alert('點名記錄已鎖定，無法修改');
        return;
    }
    
    const formData = $('#attendanceForm').serialize();
    
    $.post('<?= url('attendance.php') ?>', formData + '&action=save&section_id=' + sectionId + '&class_date=' + classDate + '&<?= CSRF_TOKEN_NAME ?>=' + csrfToken, function(res) {
        if (res.success) {
            showToast(res.message, 'success');
        } else {
            alert(res.message);
        }
    });
}

function lockDate() {
    if (!confirm('確定要鎖定此日期的點名記錄嗎？鎖定後需由管理員解鎖才能修改。')) return;
    
    $.post('<?= url('attendance.php') ?>', {
        action: 'lock',
        section_id: sectionId,
        class_date: classDate,
        <?= CSRF_TOKEN_NAME ?>: csrfToken
    }, function(res) {
        if (res.success) location.reload();
        else alert(res.message);
    });
}

function unlockDate() {
    if (!confirm('確定要解鎖此日期的點名記錄嗎？')) return;
    
    $.post('<?= url('attendance.php') ?>', {
        action: 'unlock',
        section_id: sectionId,
        class_date: classDate,
        <?= CSRF_TOKEN_NAME ?>: csrfToken
    }, function(res) {
        if (res.success) location.reload();
        else alert(res.message);
    });
}

// 快捷鍵
$(document).keydown(function(e) {
    if (e.ctrlKey && e.key === 's') {
        e.preventDefault();
        saveAttendance();
    }
});
</script>
