<?php
/**
 * ISLMS - 成績單管理
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check() || !$auth->hasRole(['admin', 'staff'])) {
    setFlash('error', '權限不足');
    header('Location: ' . APP_URL . '/dashboard.php');
    exit;
}

$sectionModel = new SectionModel();
$enrollmentModel = new EnrollmentModel();
$gradeModel = new GradeModel();

$sectionId = (int) ($_GET['section_id'] ?? 0);

// 產生 PDF (簡化版 - 實際應使用 TCPDF 或 DOMPDF)
if (isset($_GET['generate']) && $sectionId) {
    $enrollmentId = (int) $_GET['generate'];
    $enrollment = $enrollmentModel->getWithDetails($enrollmentId);
    
    if (!$enrollment) {
        setFlash('error', '選課記錄不存在');
        header('Location: ' . APP_URL . '/transcripts.php?section_id=' . $sectionId);
        exit;
    }
    
    // 取得成績
    $grades = $gradeModel->getByEnrollment($enrollmentId);
    
    // 簡易 HTML 成績單輸出
    header('Content-Type: text/html; charset=utf-8');
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>成績單 - <?= e($enrollment['name']) ?></title>
        <style>
            body { font-family: "Microsoft JhengHei", sans-serif; padding: 40px; }
            .header { text-align: center; margin-bottom: 30px; }
            .header h1 { font-size: 24px; margin: 0; }
            .header h2 { font-size: 18px; color: #666; margin: 5px 0; }
            .info { margin-bottom: 30px; }
            .info table { width: 100%; }
            .info td { padding: 5px 10px; }
            .info .label { color: #666; width: 100px; }
            .grades { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
            .grades th, .grades td { border: 1px solid #ddd; padding: 10px; text-align: center; }
            .grades th { background: #f5f5f5; }
            .total { font-size: 18px; text-align: right; }
            .footer { margin-top: 50px; text-align: center; color: #999; font-size: 12px; }
            @media print { body { padding: 20px; } }
        </style>
    </head>
    <body>
        <div class="header">
            <h1>華語教學中心</h1>
            <h2>Chinese Language Center</h2>
            <h2 style="margin-top: 20px;">成績單 Transcript</h2>
        </div>
        
        <div class="info">
            <table>
                <tr>
                    <td class="label">學號 Student ID:</td>
                    <td><?= e($enrollment['student_no']) ?></td>
                    <td class="label">學期 Semester:</td>
                    <td><?= e($enrollment['semester']) ?></td>
                </tr>
                <tr>
                    <td class="label">姓名 Name:</td>
                    <td><?= e($enrollment['name']) ?> <?= $enrollment['chinese_name'] ? '(' . e($enrollment['chinese_name']) . ')' : '' ?></td>
                    <td class="label">程度 Level:</td>
                    <td><?= e($enrollment['level_code']) ?></td>
                </tr>
                <tr>
                    <td class="label">課程 Course:</td>
                    <td colspan="3"><?= e($enrollment['course_name']) ?> - <?= e($enrollment['section_name']) ?></td>
                </tr>
            </table>
        </div>
        
        <table class="grades">
            <thead>
                <tr>
                    <th>評分項目 Item</th>
                    <th>權重 Weight</th>
                    <th>分數 Score</th>
                    <th>加權分數 Weighted</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($grades as $g): ?>
                <tr>
                    <td><?= e($g['item_name']) ?></td>
                    <td><?= $g['weight'] ?>%</td>
                    <td><?= $g['score'] !== null ? $g['score'] : '-' ?></td>
                    <td><?= $g['weighted_score'] !== null ? number_format($g['weighted_score'], 1) : '-' ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <div class="total">
            <strong>總分 Final Score: <?= $enrollment['final_score'] !== null ? number_format($enrollment['final_score'], 1) : '-' ?></strong>
            <span style="margin-left: 30px;">等第 Grade: <?= $enrollment['final_grade'] ?? '-' ?></span>
            <span style="margin-left: 30px;">出席率 Attendance: <?= $enrollment['attendance_rate'] !== null ? $enrollment['attendance_rate'] . '%' : '-' ?></span>
        </div>
        
        <div class="footer">
            <p>列印日期 Print Date: <?= date('Y-m-d H:i') ?></p>
            <button onclick="window.print()" style="padding: 10px 30px; cursor: pointer;">列印 Print</button>
        </div>
    </body>
    </html>
    <?php
    exit;
}

if ($sectionId) {
    $section = $sectionModel->getWithDetails($sectionId);
    if (!$section) {
        setFlash('error', '班級不存在');
        header('Location: ' . APP_URL . '/transcripts.php');
        exit;
    }
    
    $students = $sectionModel->getAllStudents($sectionId);
    
    $pageTitle = '成績單 - ' . $section['section_name'] . ' - ' . APP_NAME;
    $breadcrumb = [['title' => '成績單', 'url' => url('transcripts.php')], ['title' => $section['section_name'], 'active' => true]];
    
    ob_start();
    ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0"><?= e($section['course_name']) ?> - <?= e($section['section_name']) ?></h1>
        <a href="<?= url('transcripts.php') ?>" class="btn btn-outline-secondary"><i class="bi bi-arrow-left me-1"></i>返回</a>
    </div>
    
    <div class="card">
        <div class="card-header"><i class="bi bi-file-earmark-pdf me-2"></i>成績單列表</div>
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0">
                    <thead>
                        <tr>
                            <th>學號</th>
                            <th>姓名</th>
                            <th class="text-center">總分</th>
                            <th class="text-center">等第</th>
                            <th class="text-center">出席率</th>
                            <th class="text-center">狀態</th>
                            <th width="150">操作</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($students as $s): ?>
                        <?php if ($s['enrollment_status'] !== 'active') continue; ?>
                        <tr>
                            <td><?= e($s['student_no']) ?></td>
                            <td><?= e($s['name']) ?><?= $s['chinese_name'] ? '<br><small class="text-muted">' . e($s['chinese_name']) . '</small>' : '' ?></td>
                            <td class="text-center fw-bold"><?= $s['final_score'] !== null ? number_format($s['final_score'], 1) : '-' ?></td>
                            <td class="text-center">
                                <?php if ($s['final_grade']): ?>
                                <span class="badge bg-<?= $s['final_grade'] === 'A' ? 'success' : ($s['final_grade'] === 'B' ? 'primary' : ($s['final_grade'] === 'C' ? 'warning' : 'danger')) ?>"><?= $s['final_grade'] ?></span>
                                <?php else: ?>-<?php endif; ?>
                            </td>
                            <td class="text-center"><?= $s['attendance_rate'] !== null ? $s['attendance_rate'] . '%' : '-' ?></td>
                            <td class="text-center">
                                <?php if ($s['final_score'] !== null): ?>
                                <span class="badge bg-success">可列印</span>
                                <?php else: ?>
                                <span class="badge bg-secondary">無成績</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ($s['final_score'] !== null): ?>
                                <a href="<?= url('transcripts.php?section_id=' . $sectionId . '&generate=' . $s['enrollment_id']) ?>" target="_blank" class="btn btn-sm btn-primary">
                                    <i class="bi bi-file-pdf me-1"></i>產生成績單
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <?php
    $content = ob_get_clean();
} else {
    // 班級選擇
    $sql = "SELECT s.*, o.semester, c.course_name, c.level_code
            FROM sections s
            LEFT JOIN offerings o ON s.offering_id = o.offering_id
            LEFT JOIN courses c ON o.course_id = c.course_id
            WHERE s.section_status = 'active'
            ORDER BY o.semester DESC, c.course_name, s.section_name";
    $sections = Database::getInstance()->fetchAll($sql);
    
    $pageTitle = '成績單管理 - ' . APP_NAME;
    $breadcrumb = [['title' => '成績單', 'active' => true]];
    
    ob_start();
    ?>
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0">成績單管理</h1>
    </div>
    
    <div class="alert alert-info"><i class="bi bi-info-circle me-2"></i>請選擇班級以產生成績單</div>
    
    <div class="row">
        <?php foreach ($sections as $s): ?>
        <div class="col-md-4 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <h5 class="card-title"><?= e($s['course_name']) ?></h5>
                    <h6 class="card-subtitle mb-2 text-muted"><?= e($s['section_name']) ?></h6>
                    <p class="card-text">
                        <span class="badge bg-info"><?= e($s['level_code']) ?></span>
                        <span class="badge bg-secondary"><?= e($s['semester']) ?></span>
                    </p>
                </div>
                <div class="card-footer bg-transparent">
                    <a href="<?= url('transcripts.php?section_id=' . $s['section_id']) ?>" class="btn btn-primary btn-sm w-100">
                        <i class="bi bi-file-earmark-pdf me-1"></i>管理成績單
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php
    $content = ob_get_clean();
}

$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
