<?php
/**
 * ISLMS - 系統設定
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check() || !$auth->isAdmin()) {
    setFlash('error', '權限不足');
    header('Location: ' . APP_URL . '/dashboard.php');
    exit;
}

$settingModel = new SettingModel();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $settings = [
        'center_name' => trim($_POST['center_name'] ?? ''),
        'center_name_en' => trim($_POST['center_name_en'] ?? ''),
        'school_name' => trim($_POST['school_name'] ?? ''),
        'max_students_per_section' => (int) ($_POST['max_students_per_section'] ?? 12),
        'passing_grade' => (int) ($_POST['passing_grade'] ?? 60),
        'smtp_host' => trim($_POST['smtp_host'] ?? ''),
        'smtp_port' => (int) ($_POST['smtp_port'] ?? 587),
        'smtp_user' => trim($_POST['smtp_user'] ?? ''),
        'smtp_from' => trim($_POST['smtp_from'] ?? '')
    ];
    
    // 密碼只有在有輸入時才更新
    if (!empty($_POST['smtp_pass'])) {
        $settings['smtp_pass'] = $_POST['smtp_pass'];
    }
    
    foreach ($settings as $key => $value) {
        $type = is_int($value) ? 'int' : 'string';
        $settingModel->set($key, $value, $type);
    }
    
    setFlash('success', '設定已儲存');
    header('Location: ' . APP_URL . '/settings.php');
    exit;
}

// 讀取設定
$settings = $settingModel->getAll();

$pageTitle = '系統設定 - ' . APP_NAME;
$breadcrumb = [['title' => '系統設定', 'active' => true]];

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">系統設定</h1>
</div>

<form method="post">
    <?= csrfField() ?>
    
    <div class="row">
        <div class="col-md-6">
            <!-- 基本設定 -->
            <div class="card mb-4">
                <div class="card-header"><i class="bi bi-gear me-2"></i>基本設定</div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">中心名稱 (中文)</label>
                        <input type="text" name="center_name" class="form-control" value="<?= e($settings['center_name'] ?? '華語教學中心') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">中心名稱 (英文)</label>
                        <input type="text" name="center_name_en" class="form-control" value="<?= e($settings['center_name_en'] ?? 'Chinese Language Center') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">學校名稱</label>
                        <input type="text" name="school_name" class="form-control" value="<?= e($settings['school_name'] ?? '') ?>">
                    </div>
                </div>
            </div>
            
            <!-- 課程設定 -->
            <div class="card mb-4">
                <div class="card-header"><i class="bi bi-mortarboard me-2"></i>課程設定</div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">每班人數上限</label>
                        <input type="number" name="max_students_per_section" class="form-control" min="1" max="50" value="<?= e($settings['max_students_per_section'] ?? 12) ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">及格分數</label>
                        <input type="number" name="passing_grade" class="form-control" min="0" max="100" value="<?= e($settings['passing_grade'] ?? 60) ?>">
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <!-- 郵件設定 -->
            <div class="card mb-4">
                <div class="card-header"><i class="bi bi-envelope me-2"></i>郵件設定 (SMTP)</div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">SMTP 伺服器</label>
                        <input type="text" name="smtp_host" class="form-control" placeholder="smtp.gmail.com" value="<?= e($settings['smtp_host'] ?? '') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">SMTP 連接埠</label>
                        <input type="number" name="smtp_port" class="form-control" placeholder="587" value="<?= e($settings['smtp_port'] ?? 587) ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">SMTP 帳號</label>
                        <input type="text" name="smtp_user" class="form-control" value="<?= e($settings['smtp_user'] ?? '') ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">SMTP 密碼</label>
                        <input type="password" name="smtp_pass" class="form-control" placeholder="留空則不修改">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">寄件人信箱</label>
                        <input type="email" name="smtp_from" class="form-control" value="<?= e($settings['smtp_from'] ?? '') ?>">
                    </div>
                </div>
            </div>
            
            <!-- 系統資訊 -->
            <div class="card">
                <div class="card-header"><i class="bi bi-info-circle me-2"></i>系統資訊</div>
                <div class="card-body">
                    <table class="table table-sm mb-0">
                        <tr>
                            <td class="text-muted">系統版本</td>
                            <td><?= APP_VERSION ?></td>
                        </tr>
                        <tr>
                            <td class="text-muted">PHP 版本</td>
                            <td><?= PHP_VERSION ?></td>
                        </tr>
                        <tr>
                            <td class="text-muted">伺服器時間</td>
                            <td><?= date('Y-m-d H:i:s') ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="text-center">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="bi bi-check-lg me-1"></i>儲存設定
        </button>
    </div>
</form>
<?php

$content = ob_get_clean();
$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
