<?php
/**
 * ISLMS - 班級管理
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$sectionModel = new SectionModel();
$offeringModel = new OfferingModel();
$enrollmentModel = new EnrollmentModel();
$studentModel = new StudentModel();
$userModel = new UserModel();

$action = $_GET['action'] ?? 'list';

// AJAX 處理
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
    header('Content-Type: application/json; charset=utf-8');
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $ajaxAction = $_POST['action'] ?? '';
        
        if ($ajaxAction === 'transfer' && $auth->hasRole(['admin', 'staff'])) {
            $enrollmentId = (int) ($_POST['enrollment_id'] ?? 0);
            $toSectionId = (int) ($_POST['to_section_id'] ?? 0);
            $reason = trim($_POST['reason'] ?? '');
            try {
                $enrollmentModel->transfer($enrollmentId, $toSectionId, $auth->id(), $reason);
                echo json_encode(['success' => true, 'message' => '調班成功']);
            } catch (Exception $e) {
                echo json_encode(['success' => false, 'message' => $e->getMessage()]);
            }
            exit;
        }
        
        if ($ajaxAction === 'drop' && $auth->hasRole(['admin', 'staff'])) {
            $enrollmentId = (int) ($_POST['enrollment_id'] ?? 0);
            $reason = trim($_POST['reason'] ?? '');
            try {
                $enrollmentModel->drop($enrollmentId, $auth->id(), $reason);
                echo json_encode(['success' => true, 'message' => '退選成功']);
            } catch (Exception $e) {
                echo json_encode(['success' => false, 'message' => $e->getMessage()]);
            }
            exit;
        }
        
        if ($ajaxAction === 'add_student' && $auth->hasRole(['admin', 'staff'])) {
            $sectionId = (int) ($_POST['section_id'] ?? 0);
            $studentId = (int) ($_POST['student_id'] ?? 0);
            try {
                $enrollmentModel->addToSection($studentId, $sectionId, $auth->id());
                echo json_encode(['success' => true, 'message' => '學生已加入']);
            } catch (Exception $e) {
                echo json_encode(['success' => false, 'message' => $e->getMessage()]);
            }
            exit;
        }
        
        if ($ajaxAction === 'search_students') {
            $keyword = trim($_POST['keyword'] ?? '');
            $sectionId = (int) ($_POST['section_id'] ?? 0);
            $section = $sectionModel->getWithDetails($sectionId);
            if (!$section) {
                echo json_encode(['success' => false, 'data' => []]);
                exit;
            }
            $sql = "SELECT s.* FROM students s 
                    WHERE s.level_code = ? AND s.status = 1
                    AND (s.student_no LIKE ? OR s.name LIKE ? OR s.chinese_name LIKE ?)
                    AND NOT EXISTS (
                        SELECT 1 FROM enrollments e JOIN sections sec ON e.section_id = sec.section_id
                        WHERE e.student_id = s.student_id AND sec.offering_id = ? AND e.enrollment_status = 'active'
                    ) LIMIT 20";
            $db = Database::getInstance();
            $students = $db->fetchAll($sql, [$section['level_code'], "%{$keyword}%", "%{$keyword}%", "%{$keyword}%", $section['offering_id']]);
            echo json_encode(['success' => true, 'data' => $students]);
            exit;
        }
    }
    exit;
}

switch ($action) {
    case 'create':
        if (!$auth->hasRole(['admin', 'staff'])) {
            setFlash('error', '權限不足');
            header('Location: ' . APP_URL . '/sections.php');
            exit;
        }
        $offeringId = (int) ($_GET['offering_id'] ?? 0);
        $offering = $offeringModel->getWithDetails($offeringId);
        if (!$offering) {
            setFlash('error', '請先選擇開班');
            header('Location: ' . APP_URL . '/offerings.php');
            exit;
        }
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'offering_id' => $offeringId,
                'section_name' => trim($_POST['section_name'] ?? ''),
                'teacher_id' => (int) ($_POST['teacher_id'] ?? 0) ?: $offering['teacher_id'],
                'classroom' => trim($_POST['classroom'] ?? '') ?: $offering['classroom'],
                'max_students' => (int) ($_POST['max_students'] ?? 12),
                'current_count' => 0,
                'section_status' => 'active',
                'updated_by' => $auth->user()['account']
            ];
            if (!empty($data['section_name'])) {
                $sectionModel->create($data);
                setFlash('success', '班級已新增');
                header('Location: ' . APP_URL . '/offerings.php?action=view&id=' . $offeringId);
                exit;
            }
            $errors[] = '班級名稱為必填';
        }
        $teachers = $userModel->getTeachers();
        $pageTitle = '新增班級 - ' . APP_NAME;
        $breadcrumb = [['title' => '開班管理', 'url' => url('offerings.php')], ['title' => '新增班級', 'active' => true]];
        ob_start();
        include VIEW_PATH . '/sections/form.php';
        $content = ob_get_clean();
        break;
        
    case 'view':
        $id = (int) ($_GET['id'] ?? 0);
        $section = $sectionModel->getWithDetails($id);
        if (!$section) {
            setFlash('error', '班級不存在');
            header('Location: ' . APP_URL . '/sections.php');
            exit;
        }
        if ($auth->isTeacher()) {
            $teacherSections = $sectionModel->getByTeacher($auth->id());
            if (!in_array($id, array_column($teacherSections, 'section_id'))) {
                setFlash('error', '您沒有權限查看此班級');
                header('Location: ' . APP_URL . '/sections.php');
                exit;
            }
        }
        $students = $sectionModel->getAllStudents($id);
        $otherSections = array_filter($sectionModel->getByOffering($section['offering_id']), fn($s) => $s['section_id'] != $id);
        $pageTitle = $section['section_name'] . ' - ' . APP_NAME;
        $breadcrumb = [['title' => '班級管理', 'url' => url('sections.php')], ['title' => $section['section_name'], 'active' => true]];
        ob_start();
        include VIEW_PATH . '/sections/view.php';
        $content = ob_get_clean();
        break;
        
    default:
        if ($auth->isTeacher()) {
            $sections = $sectionModel->getByTeacher($auth->id());
        } else {
            $sql = "SELECT s.*, o.semester, o.class_time, o.schedule, c.course_name, c.level_code, u.name as teacher_name
                    FROM sections s
                    LEFT JOIN offerings o ON s.offering_id = o.offering_id
                    LEFT JOIN courses c ON o.course_id = c.course_id
                    LEFT JOIN users u ON COALESCE(s.teacher_id, o.teacher_id) = u.user_id
                    WHERE o.offering_status = 'active'
                    ORDER BY c.course_name, s.section_name";
            $sections = Database::getInstance()->fetchAll($sql);
        }
        $pageTitle = '班級管理 - ' . APP_NAME;
        $breadcrumb = [['title' => '班級管理', 'active' => true]];
        ob_start();
        include VIEW_PATH . '/sections/index.php';
        $content = ob_get_clean();
}

$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
