<?php
/**
 * ISLMS - 統計報表
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$attendanceModel = new AttendanceModel();
$gradeModel = new GradeModel();
$offeringModel = new OfferingModel();

$reportType = $_GET['type'] ?? 'attendance';
$filters = [
    'offering_id' => $_GET['offering_id'] ?? '',
    'section_id' => $_GET['section_id'] ?? '',
    'start_date' => $_GET['start_date'] ?? '',
    'end_date' => $_GET['end_date'] ?? '',
    'level_code' => $_GET['level_code'] ?? ''
];

// 匯出 CSV
if (isset($_GET['export']) && $_GET['export'] === 'csv') {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="report_' . date('Ymd_His') . '.csv"');
    $output = fopen('php://output', 'w');
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));
    
    if ($reportType === 'attendance') {
        $data = $attendanceModel->getReport($filters);
        fputcsv($output, ['學號', '姓名', '課程', '班級', '程度', '總堂數', '出席', '遲到', '缺席', '請假', '出席率']);
        foreach ($data as $row) {
            fputcsv($output, [$row['student_no'], $row['student_name'], $row['course_name'], $row['section_name'], $row['level_code'], $row['total_classes'], $row['present'], $row['late'], $row['absent'], $row['leave_count'], $row['attendance_rate'] . '%']);
        }
    } else {
        $data = $gradeModel->getGradeReport($filters);
        fputcsv($output, ['學號', '姓名', '課程', '班級', '程度', '總分', '等第', '出席率']);
        foreach ($data as $row) {
            fputcsv($output, [$row['student_no'], $row['student_name'], $row['course_name'], $row['section_name'], $row['level_code'], $row['final_score'] ?? '-', $row['final_grade'] ?? '-', $row['attendance_rate'] ? $row['attendance_rate'] . '%' : '-']);
        }
    }
    fclose($output);
    exit;
}

$reportData = $reportType === 'attendance' ? $attendanceModel->getReport($filters) : $gradeModel->getGradeReport($filters);
$offerings = $offeringModel->getAllWithDetails('', 'active');
$levels = (new LevelModel())->getActive();

$pageTitle = '統計報表 - ' . APP_NAME;
$breadcrumb = [['title' => '統計報表', 'active' => true]];

ob_start();
include VIEW_PATH . '/reports/index.php';
$content = ob_get_clean();

$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
