<?php
/**
 * ISLMS - 個人資料
 */
require_once __DIR__ . '/config/config.php';

$auth = Auth::getInstance();
if (!$auth->check()) {
    header('Location: ' . APP_URL . '/login.php');
    exit;
}

$userModel = new UserModel();
$user = $userModel->find($auth->id());

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'name' => trim($_POST['name'] ?? ''),
        'name_en' => trim($_POST['name_en'] ?? ''),
        'email' => trim($_POST['email'] ?? ''),
        'phone' => trim($_POST['phone'] ?? ''),
        'updated_by' => $auth->user()['account']
    ];
    
    $errors = [];
    if (empty($data['name'])) $errors[] = '姓名為必填';
    
    if (empty($errors)) {
        $userModel->update($auth->id(), $data);
        setFlash('success', '個人資料已更新');
        header('Location: ' . APP_URL . '/profile.php');
        exit;
    }
}

$pageTitle = '個人資料 - ' . APP_NAME;
$breadcrumb = [['title' => '個人資料', 'active' => true]];

ob_start();
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3 mb-0">個人資料</h1>
</div>

<?php if (!empty($errors)): ?>
<div class="alert alert-danger"><ul class="mb-0"><?php foreach ($errors as $e): ?><li><?= e($e) ?></li><?php endforeach; ?></ul></div>
<?php endif; ?>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form method="post">
                    <?= csrfField() ?>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">帳號</label>
                            <input type="text" class="form-control" value="<?= e($user['account']) ?>" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">角色</label>
                            <input type="text" class="form-control" value="<?= getRoleName($user['role']) ?>" readonly>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">中文姓名 <span class="text-danger">*</span></label>
                            <input type="text" name="name" class="form-control" required value="<?= e($_POST['name'] ?? $user['name']) ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">英文姓名</label>
                            <input type="text" name="name_en" class="form-control" value="<?= e($_POST['name_en'] ?? $user['name_en']) ?>">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Email</label>
                            <input type="email" name="email" class="form-control" value="<?= e($_POST['email'] ?? $user['email']) ?>">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">電話</label>
                            <input type="text" name="phone" class="form-control" value="<?= e($_POST['phone'] ?? $user['phone']) ?>">
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary"><i class="bi bi-check-lg me-1"></i>儲存變更</button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header"><i class="bi bi-info-circle me-2"></i>帳號資訊</div>
            <div class="card-body">
                <p><strong>建立時間：</strong><br><?= formatDateTime($user['create_date']) ?></p>
                <p><strong>最後登入：</strong><br><?= $user['last_login_at'] ? formatDateTime($user['last_login_at']) : '從未登入' ?></p>
                <hr>
                <a href="<?= url('password.php') ?>" class="btn btn-outline-warning w-100">
                    <i class="bi bi-key me-1"></i>變更密碼
                </a>
            </div>
        </div>
    </div>
</div>
<?php

$content = ob_get_clean();
$layout = 'main';
include VIEW_PATH . '/layouts/main.php';
